/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class FileSystemTime
implements Comparable<FileSystemTime> {
    private final long seconds;
    private final long nanoseconds;

    public FileSystemTime(long seconds) {
        this.seconds = seconds;
        this.nanoseconds = 0L;
    }

    public FileSystemTime(long seconds, long nanoseconds) {
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    public long getJavaTime() {
        return this.seconds * 1000L + this.nanoseconds / 1000L;
    }

    public long getWindowsFilesystemTime() {
        return this.nanoseconds + (this.seconds + 11644473600L) * 10000000L;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FileSystemTime)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        FileSystemTime other = (FileSystemTime)object;
        return this.seconds == other.seconds && this.nanoseconds == other.nanoseconds;
    }

    @Override
    public int compareTo(FileSystemTime other) {
        Check.notNull(other, "other");
        if (this.seconds < other.seconds) {
            return -1;
        }
        if (this.seconds > other.seconds) {
            return 1;
        }
        if (this.nanoseconds < other.nanoseconds) {
            return -1;
        }
        if (this.nanoseconds > other.nanoseconds) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + (int)(this.seconds ^ this.seconds >>> 32);
        hashCode = 31 * hashCode + (int)(this.nanoseconds ^ this.nanoseconds >>> 32);
        return hashCode;
    }

    public String toString() {
        return MessageFormat.format("FileSystemTime [seconds={0}, nanoseconds={1}]", this.seconds, this.nanoseconds);
    }
}

