/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class ResourceForkInputStream
extends InputStream {
    public static final String RESOURCEFORK_NAME = "com.apple.ResourceFork";
    private final String filename;
    private long position = 0L;

    public ResourceForkInputStream(String filename) throws FileNotFoundException {
        Check.notNull(filename, "filename");
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(MessageFormat.format(Messages.getString("ResourceForkInputStream.DataForkForFileDoesNotExistFormat"), filename));
        }
        this.filename = filename;
    }

    @Override
    public int read() throws IOException {
        byte[] readBytes = new byte[1];
        if (this.read(readBytes, 0, 1) < 0) {
            return -1;
        }
        return readBytes[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        byte[] readbuf = off == 0 ? buffer : new byte[len];
        int readlen = FileSystemUtils.getInstance().readMacExtendedAttribute(this.filename, RESOURCEFORK_NAME, readbuf, len, this.position);
        if (readlen == -1) {
            return -1;
        }
        if (readlen == -2) {
            throw new IOException("Could not read resource fork due to internal error");
        }
        if (off != 0) {
            System.arraycopy(readbuf, 0, buffer, off, len);
        }
        this.position += (long)readlen;
        return readlen;
    }
}

