/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.decoder.entry;

import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.StreamChunkedDecoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class AppleForkedResourceForkDecoder
extends StreamChunkedDecoder
implements AppleForkedEntryDecoder {
    public AppleForkedResourceForkDecoder(AppleForkedEntryDescriptor descriptor, File dataFile) throws FileNotFoundException {
        Check.notNull(descriptor, "descriptor");
        Check.isTrue(descriptor.getType() == 2L, "descriptor.getType() == AppleForkedConstants.ID_RESOURCEFORK");
        this.setBufferSize(descriptor.getLength());
        this.setStream(new FileOutputStream(this.getResourceFile(dataFile)));
    }

    private final File getResourceFile(File dataFile) {
        String filename;
        try {
            filename = dataFile.getCanonicalPath();
        }
        catch (Exception e) {
            filename = dataFile.getAbsolutePath();
        }
        if (!dataFile.exists()) {
            try {
                FileOutputStream dataTemp = new FileOutputStream(dataFile);
                dataTemp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new File(filename + "/..namedfork/rsrc");
    }
}

