/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.wincredential;

import com.microsoft.tfs.jni.WinCredential;
import com.microsoft.tfs.jni.loader.NativeLoader;

public class NativeWinCredential {
    public boolean storeCredential(WinCredential credential) {
        return NativeWinCredential.nativeStoreCredential(credential.getServerUri(), credential.getAccountName(), credential.getPassword());
    }

    public WinCredential findCredential(WinCredential credential) {
        Object winCredential = NativeWinCredential.nativeFindCredential(credential.getServerUri());
        if (winCredential == null) {
            return null;
        }
        return (WinCredential)winCredential;
    }

    public boolean eraseCredential(WinCredential cred) {
        return NativeWinCredential.nativeEraseCredential(cred.getServerUri());
    }

    private static native boolean nativeStoreCredential(String var0, String var1, String var2);

    private static native Object nativeFindCredential(String var0);

    private static native boolean nativeEraseCredential(String var0);

    static {
        NativeLoader.loadLibraryAndLogError("native_credential");
    }
}

