/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.email;

import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.StringUtil;
import java.text.MessageFormat;

public class EmailAddressParser {
    public static final char BACKSLASH = '\\';
    public static final char QUOTE = '\"';
    public static final char DOT = '.';
    public static final char AT = '@';
    public static final char HYPHEN = '-';
    public static final String ALLOWED_SPECIALS = "!#$%&'*+-/=?^_`.{|}~";
    public static final String ALLOWED_QUOTED_SPECIALS = "(),:;<> ";
    public static final String REQUIRE_QUOTING = "\",[]@\\";
    public static final String MANY_DOTS = "..";
    public static final char BOL = '\ufffe';
    public static final char EOL = '\uffff';
    private String buff;
    private String emailAddress;
    private String errorMessage = null;
    private boolean inQuote = false;
    private int idx;
    private int lastQuoteIdx;
    private char curRawChar;
    private char prevRawChar;
    private char curChar;
    private char prevChar;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean parse(String emailAddress) {
        this.emailAddress = StringUtil.isNullOrEmpty(emailAddress) ? "" : emailAddress.trim();
        this.buff = this.emailAddress + '\uffff';
        this.errorMessage = null;
        this.inQuote = false;
        this.idx = -1;
        this.lastQuoteIdx = -1;
        this.curRawChar = (char)65534;
        this.prevRawChar = (char)65534;
        this.curChar = (char)65534;
        this.prevChar = (char)65534;
        if (this.emailAddress.length() == 0) {
            return true;
        }
        if (this.emailAddress.length() > 256) {
            this.errorMessage = Messages.getString("EmailAddressParser.AddressTooLong");
            return false;
        }
        if (this.parseLocalPart()) {
            if (this.curChar == '\"' && this.getRawChar() == '\uffff') {
                String errorMessageFormat = Messages.getString("EmailAddressParser.UnexpectedEolInQuoteFormat");
                this.errorMessage = MessageFormat.format(errorMessageFormat, Character.valueOf(this.curChar), this.lastQuoteIdx + 1);
                return false;
            }
            if (this.curRawChar == '\uffff') {
                this.errorMessage = Messages.getString("EmailAddressParser.MissingDomainpart");
                return false;
            }
            if (this.curRawChar != '@') {
                String errorMessageFormat = Messages.getString("EmailAddressParser.UnallowedCharacterFormat");
                this.errorMessage = MessageFormat.format(errorMessageFormat, Character.valueOf(this.curRawChar), this.idx + 1);
                return false;
            }
            return this.parseDomainPart();
        }
        return false;
    }

    private boolean parseLocalPart() {
        StringBuilder sb;
        block10: {
            sb = new StringBuilder(this.buff.length());
            while (true) {
                if (this.getChar() == '\uffff') {
                    if (this.inQuote) {
                        String errorMessageFormat = Messages.getString("EmailAddressParser.UnexpectedEolInQuoteFormat");
                        this.errorMessage = MessageFormat.format(errorMessageFormat, this.lastQuoteIdx + 1);
                    } else {
                        this.errorMessage = Messages.getString("EmailAddressParser.UnexpectedEol");
                    }
                    return false;
                }
                if (this.curChar == '\"' && this.idx == 0) {
                    this.inQuote = !this.inQuote;
                    this.lastQuoteIdx = this.idx;
                    continue;
                }
                if (this.isEndOfLocalPart()) break block10;
                if (this.idx > 64) {
                    this.errorMessage = Messages.getString("EmailAddressParser.LocalPartTooLong");
                    return false;
                }
                if (!this.isAllowed(this.curChar)) break;
                sb.append(this.curChar);
            }
            String errorMessageFormat = Messages.getString("EmailAddressParser.UnallowedCharacterFormat");
            this.errorMessage = MessageFormat.format(errorMessageFormat, Character.valueOf(this.curChar), this.idx + 1);
            return false;
        }
        if (sb.length() == 0) {
            this.errorMessage = Messages.getString("EmailAddressParser.EmptyLocalpart");
            return false;
        }
        if (sb.charAt(0) == '.') {
            this.errorMessage = Messages.getString("EmailAddressParser.DotAtBeginning");
            return false;
        }
        if (sb.charAt(sb.length() - 1) == '.') {
            this.errorMessage = Messages.getString("EmailAddressParser.DotAtEnd");
            return false;
        }
        if (sb.indexOf(MANY_DOTS) > -1) {
            this.errorMessage = Messages.getString("EmailAddressParser.ManyDots");
            return false;
        }
        return true;
    }

    private boolean parseDomainPart() {
        if (this.getRawChar() == '\uffff') {
            this.errorMessage = Messages.getString("EmailAddressParser.MissingDomainpart");
            return false;
        }
        String domainPart = this.emailAddress.toLowerCase().substring(this.idx);
        if (domainPart.length() > 253) {
            this.errorMessage = Messages.getString("EmailAddressParser.DomainTooLong");
            return false;
        }
        String[] labels = domainPart.split("\\.", -1);
        if (labels.length > 127) {
            this.errorMessage = Messages.getString("EmailAddressParser.TooManyDomainLevels");
            return false;
        }
        if (StringUtil.isNullOrEmpty(labels[0])) {
            this.errorMessage = Messages.getString("EmailAddressParser.DomainCannotStartWithDot");
            return false;
        }
        if (StringUtil.isNullOrEmpty(labels[labels.length - 1])) {
            this.errorMessage = Messages.getString("EmailAddressParser.DomainCannotEndWithDot");
            return false;
        }
        for (String label : labels) {
            if (StringUtil.isNullOrEmpty(label)) {
                this.errorMessage = Messages.getString("EmailAddressParser.SubdomainCannotBeEmpty");
                return false;
            }
            if (label.length() > 63) {
                this.errorMessage = Messages.getString("EmailAddressParser.SubdomainTooLong");
                return false;
            }
            if (label.charAt(0) == '-') {
                this.errorMessage = Messages.getString("EmailAddressParser.SubdomainCannotStartWithHyphen");
                return false;
            }
            if (label.charAt(label.length() - 1) == '-') {
                this.errorMessage = Messages.getString("EmailAddressParser.SubdomainCannotEndWithHyphen");
                return false;
            }
            for (char c : label.toCharArray()) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-') continue;
                this.errorMessage = Messages.getString("EmailAddressParser.WrongCharacterInSubdomain");
                return false;
            }
        }
        return true;
    }

    private char getRawChar() {
        if (this.curRawChar == '\uffff') {
            return '\uffff';
        }
        this.prevRawChar = this.curRawChar;
        this.curRawChar = this.buff.charAt(++this.idx);
        return this.curRawChar;
    }

    private char getChar() {
        if (this.curChar == '\uffff') {
            return '\uffff';
        }
        this.prevChar = this.curChar;
        if (this.getRawChar() == '\uffff') {
            this.curChar = '\uffff';
            return '\uffff';
        }
        if (this.curRawChar == '\\' && this.inQuote) {
            this.curChar = this.getRawChar();
            return this.curChar;
        }
        this.curChar = this.curRawChar;
        return this.curChar;
    }

    private boolean isAllowed(char c) {
        if (this.isAlphaDigit(c)) {
            return true;
        }
        if (ALLOWED_SPECIALS.indexOf(c) > -1) {
            return true;
        }
        if (this.inQuote) {
            if (ALLOWED_QUOTED_SPECIALS.indexOf(c) > -1) {
                return true;
            }
            if (REQUIRE_QUOTING.indexOf(c) > -1 && this.prevRawChar == '\\') {
                return true;
            }
        }
        return false;
    }

    private boolean isAlphaDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private boolean isQuotedChar() {
        return this.prevRawChar == '\\';
    }

    private boolean isEndOfLocalPart() {
        if (this.inQuote) {
            return this.curChar == '\"' && !this.isQuotedChar();
        }
        return this.curChar == '@' && !this.isQuotedChar();
    }
}

