/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class SequenceRecognizer<STATE extends Enum<STATE>>
extends RecognizerBase<STATE> {
    private final UnmodifiableList<ITokenMatcher> matchTerms;
    private final boolean reportStartOfMatch;

    SequenceRecognizer(List<ITokenMatcher> matchTerms, boolean reportStartOfMatch) {
        this.reportStartOfMatch = reportStartOfMatch;
        this.matchTerms = CollectionUtils.asUnmodifiable(new ArrayList<ITokenMatcher>(matchTerms));
    }

    @Override
    public int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset + this.matchTerms.size() > tokens.size()) {
            return -1;
        }
        int offset = startOffset;
        for (ITokenMatcher matcher : this.matchTerms) {
            if (matcher.matches(tokens.get(offset++))) continue;
            return -1;
        }
        if (this.reportStartOfMatch) {
            return startOffset;
        }
        return offset;
    }

    @Override
    protected String getRecognizerStringRepresentation() {
        return "sequence" + this.matchTermString();
    }

    protected final String matchTermString() {
        return StringUtils.concat(this.matchTerms, (String)", ");
    }
}

