/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.calladapter;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;

final class SynchronousBodyCallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;

    SynchronousBodyCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public @NonNull Type responseType() {
        return this.responseType;
    }

    public @Nullable Object adapt(@NonNull Call<R> call) {
        try {
            Optional<R> response = Retrofit.executeServiceCall(call);
            return response.orElse(null);
        }
        catch (ServiceCallException e) {
            throw SynchronousBodyCallAdapter.sneakyThrow(e);
        }
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

