This check detects `friend` declarations outside the private section in a class definition.

# Why is This a Problem?

It is recommended to have these declarations in the private section of the class to not pollute (in the sense of readability) the public section, i.e. when reading the public interface of a class, as `friend` declaration is more of an implementation detail.

# How Can I Resolve This?

Move `friend` declarations to the private section of the class.

## Example (Before)

```CPP
class Y {
private:
    int data;
public:
    friend void friend_set(X& p, int i);
    void test();
};
```

## Example (After)

```CPP
class Y {
private:
    int data;
    friend void friend_set(X& p, int i);
public:
    void test();
};
```
# Where Can I Learn More?

## Guidelines

- [C++ reference: Friend declaration](https://en.cppreference.com/w/cpp/language/friend)