This check detects if a pointer parameter type, property type, or return type is marked with nullability annotations (nullable, nonnull, _Nullable, _Nonnull) in Objective-C and Objective-C++.

# Why is This a Problem?
It is recommended to designate a pointer parameter type, property type, or return type with nullability annotations. Without nullability annotations, it may not be clear whether a particular pointer can be nil or not.

# How Can I Resolve This?

You should annotate all pointer parameter type, property type, or return type with nullability annotations.

# Where Can I Learn More?

## Guidelines

- [Designating Nullability in Objective-C APIs](https://developer.apple.com/documentation/swift/designating-nullability-in-objective-c-apis)