As computational power increases, so does the ability to break ciphers with
smaller key lengths. The recommended key length size for RSA and DSA algorithms
is 2048 and higher. 1024 bits and below are now considered breakable. EC key
length sizes are recommended to be 224 and higher with 160 and below considered
breakable. This plugin test checks for use of any key less than those limits
and returns a high severity error if lower than the lower threshold and a
medium severity error for those lower than the higher threshold.

## Example


In the following code snippet the issue is: DSA key sizes below 1024 bits are considered breakable.
For more information on this see: CWE-326 (https://cwe.mitre.org/data/definitions/326.html)
``` python
 # Also incorrect: without keyword args
 dsa.generate_private_key(512,
                          backends.default_backend())
 rsa.generate_private_key(3,
```
## see also:

- https://csrc.nist.gov/publications/detail/sp/800-131a/rev-2/final
- https://security.openstack.org/guidelines/dg_strong-crypto.html
- https://cwe.mitre.org/data/definitions/326.html

New in version  0.14.0

Changed in version  1.7.3
CWE information added
