Disallows declaring empty lifecycle methods

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngAfterContentChecked() {}
  ~~~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test extends BaseDirective {
  ngAfterContentInit() {}
  ~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test extends BaseTest implements AfterViewChecked, OnDestroy {
  'ngAfterViewChecked'() {}
  ~~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ['ngAfterViewInit']() {}
  ~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import { HttpInterceptor } from '@angular/common/http';
import {
  DoCheck,
  DoBootstrap
} from '@angular/core';
@Pipe()
class Test {
  [`ngDoBootstrap`]() {}
  ~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import {
  AfterViewChecked,
  DoCheck,
  AfterViewInit,
} from '@angular/core';
@Component()
class Test
    implements AfterViewChecked,
                AfterViewInit,
                DoCheck {
  ngDoCheck() {}
  ~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import {OnChanges, AfterContentInit} from '@angular/core';
@Directive()
class Test implements OnChanges, AfterContentInit {
  ngOnChanges() {}
  ~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import * as ng from '@angular/core';
@Injectable()
class Test implements ng.OnDestroy {
  ngOnDestroy() {}
  ~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import {DoBootstrap, OnInit} from '@angular/core';
@NgModule()
class Test implements OnInit, DoBootstrap {
  ngOnInit() {
    this.init();
  }
}

@NgModule()
class Test2 implements OnInit, DoBootstrap {
  ngOnInit() {}
  ~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test extends BaseComponent<unknown> implements OnInit {
  ngOnInit() {}
  ~~~~~~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngAfterContentChecked() { console.log('AfterContentChecked'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngAfterContentInit() { console.log('AfterContentInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class Test {
  ngAfterViewChecked() { console.log('AfterViewChecked'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule()
class Test {
  ngAfterViewInit() { console.log('AfterViewInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe()
class Test {
  ngDoBootstrap() { console.log('DoBootstrap'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngDoCheck() { console.log('DoCheck'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngOnChanges() { console.log('OnChanges'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class Test {
  ngOnDestroy() { console.log('OnDestroy'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule()
class Test {
  ngOnInit() { console.log('OnInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  [ngOnInit]() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {
  ngOnInit() {}
}
```

</details>
