[Accessibility] Ensures that the `autofocus` attribute is not used

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<button autofocus>Click me!</button>
        ~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [attr.autofocus]="false">
       ~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<app-test [autofocus]="true"></app-test>
<select autofocus></select>
        ~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<input type="text">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<textarea autoFocus></textarea>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div [autoFocus]="true"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [appautofocus]="false">Click me!</button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-drag-drop autofocus></app-drag-drop>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-textarea [autofocus]="false"></app-textarea>
```

</details>
