<h2>Why is this an issue?</h2>
<p>The <code>switch</code> statement should be used only to clearly define some new branches in the control flow. As soon as a <code>case</code>
clause contains too many statements this highly decreases the readability of the overall control flow statement. In such case, the content of the
<code>case</code> clause should be extracted into a dedicated method.</p>
<h3>Noncompliant code example</h3>
<p>With the default threshold of 8:</p>
<pre>
switch (myVariable)
{
    case 0: // Noncompliant: 9 statements in the case
        methodCall1("");
        methodCall2("");
        methodCall3("");
        methodCall4("");
        methodCall5("");
        methodCall6("");
        methodCall7("");
        methodCall8("");
        methodCall9("");
        break;
    case 1:
        ...
}
</pre>
<h3>Compliant solution</h3>
<pre>
switch (myVariable)
{
    case 0:
        DoSomething()
        break;
    case 1:
        ...
}
...
private void DoSomething()
{
    methodCall1("");
    methodCall2("");
    methodCall3("");
    methodCall4("");
    methodCall5("");
    methodCall6("");
    methodCall7("");
    methodCall8("");
    methodCall9("");
}
</pre>

