<h2>Why is this an issue?</h2>
<p><code>public static</code> mutable fields of classes which are accessed directly should be protected to the degree possible. This can be done by
reducing the accessibility of the field or by changing the return type to an immutable type.</p>
<p>This rule raises issues for <code>public static</code> fields with a type inheriting/implementing <code>System.Array</code> or
<code>System.Collections.Generic.ICollection&lt;T&gt;</code>.</p>
<h3>Noncompliant code example</h3>
<pre data-diff-id="1" data-diff-type="noncompliant">
public class A
{
    public static string[] strings1 = {"first","second"};  // Noncompliant
    public static List&lt;String&gt; strings3 = new List&lt;String&gt;();  // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre data-diff-id="1" data-diff-type="compliant">
public class A
{
    protected static string[] strings1 = {"first","second"};
    protected static List&lt;String&gt; strings3 = new List&lt;String&gt;();
}
</pre>
<h3>Exceptions</h3>
<p>No issue is reported:</p>
<ul>
  <li> If the type of the field inherits/implements one (at least) of the following types:
    <ul>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.objectmodel.readonlycollection-1"><code>System.Collections.ObjectModel.ReadOnlyCollection&lt;T&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.objectmodel.readonlydictionary-2"><code>System.Collections.ObjectModel.ReadOnlyDictionary&lt;TKey, TValue&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.frozen.frozendictionary-2"><code>System.Collections.Frozen.FrozenDictionary&lt;TKey, TValue&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.frozen.frozenset-1"><code>System.Collections.Frozen.FrozenSet&lt;T&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.immutablearray-1"><code>System.Collections.Immutable.ImmutableArray&lt;T&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutabledictionary-2"><code>System.Collections.Immutable.IImmutableDictionary&lt;TKey, TValue&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutablelist-1"><code>System.Collections.Immutable.IImmutableList&lt;T&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutableset-1"><code>System.Collections.Immutable.IImmutableSet&lt;T&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutablestack-1"><code>System.Collections.Immutable.IImmutableStack&lt;T&gt;</code></a> </li>
      <li> <a
      href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutablequeue-1"><code>System.Collections.Immutable.IImmutableQueue&lt;T&gt;</code></a> </li>
    </ul>  </li>
  <li> If the field is <code>readonly</code> and is initialized inline with an immutable type (i.e. inherits/implements one of the types in the
  previous list) or null. </li>
</ul>
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/582">CWE-582 - Array Declared Public, Final, and Static</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/607">CWE-607 - Public Static Final Field References Mutable Object</a> </li>
</ul>

