<h2>Why is this an issue?</h2>
<p>When defining custom attributes, <a href="https://learn.microsoft.com/en-us/dotnet/api/system.attributeusageattribute">AttributeUsageAttribute</a>
must be used to indicate where the attribute can be applied. This will:</p>
<ul>
  <li> indicate how the attribute can be used </li>
  <li> prevent it from being used at invalid locations </li>
</ul>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public sealed class MyAttribute : Attribute // Noncompliant - AttributeUsage is missing
{
    private string text;

    public MyAttribute(string text)
    {
        this.text = text;
    }

    public string Text =&gt; text;
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
[AttributeUsage(AttributeTargets.Class | AttributeTargets.Enum | AttributeTargets.Interface | AttributeTargets.Delegate)]
public sealed class MyAttribute : Attribute
{
    private string text;

    public MyAttribute(string text)
    {
        this.text = text;
    }

    public string Text =&gt; text;
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a
  href="https://learn.microsoft.com/en-us/dotnet/csharp/advanced-topics/reflection-and-attributes/creating-custom-attributes">Create custom
  attributes</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/system.attributeusageattribute">AttributeUsageAttribute class</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/system.attribute">Attribute class</a> </li>
</ul>

