﻿## SA1107

<table>
<tr>
  <td>TypeName</td>
  <td>SA1107CodeMustNotContainMultipleStatementsOnOneLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1107</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The C# code contains more than one statement on a single line.

## Rule description

A violation of this rule occurs when the code contain more than one statement on the same line. Each statement should begin on a new line.

## How to fix violations

To fix a violation of this rule, move each statement to begin on its own line.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1107:CodeMustNotContainMultipleStatementsOnOneLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1107 // CodeMustNotContainMultipleStatementsOnOneLine
#pragma warning restore SA1107 // CodeMustNotContainMultipleStatementsOnOneLine
```
