<h2>Why is this an issue?</h2>
<p>The <code>Comparable.compareTo</code> method returns a negative integer, zero, or a positive integer to indicate whether the object is less than,
equal to, or greater than the parameter. The sign of the return value or whether it is zero is what matters, not its magnitude.</p>
<p>Returning a positive or negative constant value other than the basic ones (-1, 0, or 1) provides no additional information to the caller. Moreover,
it could potentially confuse code readers who are trying to understand its purpose.</p>
<h2>How to fix it</h2>
<p>Replace any positive constant return value with 1. Replace any negative constant return value with -1.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public int compareTo(Name name) {
  if (condition) {
    return Integer.MIN_VALUE; // Noncompliant
  }
}
```
<h4>Compliant solution</h4>

```java
public int compareTo(Name name) {
  if (condition) {
    return -1; // Compliant
  }
}
```
<h4>Noncompliant code example</h4>

```java
public int compareTo(Name name) {
  if (condition) {
    return 42; // Noncompliant
  }
}
```
<h4>Compliant solution</h4>

```java
public int compareTo(Name name) {
  if (condition) {
    return 1; // Compliant
  }
}
```
<h4>Noncompliant code example</h4>
<p>It is compliant to return other values than -1, 0 or 1 if they are not constants.</p>

```java
public int compareTo(Name name) {
  if (condition) {
    return 42; // Noncompliant
  }
}
```
<h4>Compliant solution</h4>

```java
public int compareTo(Name name) {
  if (condition) {
    return hashCode() - name.hashCode(); // Compliant, not a constant
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/lang/Comparable.html#compareTo-T-">Java SE 8 API Specification:
  Comparable.compareTo</a> </li>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MIN_VALUE">Java SE 8 API Specification: Integer.MIN_VALUE</a> </li>
</ul>