<h2>Why is this an issue?</h2>
<p>In PHP, nested functions are functions, which are defined inside other functions. They have access to the variables of the enclosing functions.
Once the parent function declares the nested function, the nested function becomes available to the global scope.</p>
<p>Code that uses nested functions can become difficult to read, refactor and to maintain and should therefore be avoided.</p>
<h3>Noncompliant code example</h3>
<p>With the default threshold of 3 level:</p>

```php
function f () {
  function f_inner () {
    function f_inner_inner() {
      function f_inner_inner_inner() { // Noncompliant
      }
    }
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/functions.user-defined.php">PHP Manual - User defined functions</a> </li>
</ul>