<h2>Why is this an issue?</h2>
<p>The count of elements from an array or Countable object is always greater than or equal to zero. Testing it doesn’t make sense, since the result is
always <code>true</code>.</p>

```php
if (count($arr) >= 0) {...} // Noncompliant: always true

$result = count($arr) >= 0; // Noncompliant always true
```
<p>Similarly testing that it is less than zero will always return <code>false</code>.</p>

```php
if (count($arr) < 0) {...} // Noncompliant: always false
```
<p>Fix the code to properly check for emptiness if it was the intent, or remove the redundant code to keep the current behavior.</p>