/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core;

import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequest;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.core.ws.runtime.client.TransportRequestHandler;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportException;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportRequestHandlerCanceledException;
import com.microsoft.tfs.util.Check;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnectivityFailureRequestHandler
implements TransportRequestHandler {
    private final TFSConnection connection;

    public ConnectivityFailureRequestHandler(TFSConnection connection) {
        Check.notNull(connection, "connection");
        this.connection = connection;
    }

    @Override
    public TransportRequestHandler.Status prepareRequest(SOAPService service, SOAPRequest request, AtomicBoolean cancel) {
        if (cancel.get()) {
            this.connection.setConnectivityFailureOnLastWebServiceCall(true);
        }
        return TransportRequestHandler.Status.CONTINUE;
    }

    @Override
    public TransportRequestHandler.Status handleException(SOAPService service, SOAPRequest request, Exception exception, AtomicBoolean cancel) {
        if (exception instanceof TransportException || exception instanceof TransportRequestHandlerCanceledException) {
            this.connection.setConnectivityFailureOnLastWebServiceCall(true);
        }
        return TransportRequestHandler.Status.CONTINUE;
    }

    @Override
    public TransportRequestHandler.Status handleSuccess(SOAPService service, SOAPRequest request) {
        this.connection.setConnectivityFailureOnLastWebServiceCall(false);
        return TransportRequestHandler.Status.CONTINUE;
    }
}

