/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.internal;

import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingServerEntity;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportingFolderEntityUtils {
    private static final Log log = LogFactory.getLog(ReportingFolderEntityUtils.class);

    private ReportingFolderEntityUtils() {
    }

    public static String getFullItemPath(ReportingFolderEntity folder) {
        Check.notNull(folder, "folder");
        Stack<String> path = new Stack<String>();
        for (TFSEntity facet = folder; facet != null; facet = facet.getReferencedResource()) {
            if (facet instanceof ReportingFolderEntity) {
                String itemPath = facet.getItemPath();
                if (itemPath == null || itemPath.length() <= 0) continue;
                path.push(itemPath);
                continue;
            }
            if (facet instanceof ReportingServerEntity) break;
            log.warn((Object)MessageFormat.format("Invalid type {0} along reporting folder dependency chain", facet.getClass().getCanonicalName()));
            break;
        }
        String fullItemPath = "";
        while (path.size() > 0) {
            String pathSegment = (String)path.pop();
            pathSegment = pathSegment.trim();
            while (pathSegment.startsWith("/") || pathSegment.startsWith("\\")) {
                pathSegment = pathSegment.substring(1);
            }
            fullItemPath = URIUtils.combinePaths(fullItemPath, pathSegment);
        }
        if (fullItemPath.startsWith("/")) {
            return fullItemPath;
        }
        return "/" + fullItemPath;
    }
}

