/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionStatus;
import com.microsoft.tfs.core.clients.versioncontrol.engines.MergeEngine;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.externaltools.ExternalToolset;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.diffmerge.ThreeWayMerge;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.process.ProcessFinishedHandler;
import com.microsoft.tfs.util.process.ProcessRunner;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalConflictResolution
extends ConflictResolution
implements ProcessFinishedHandler {
    private static final Log log = LogFactory.getLog(ExternalConflictResolution.class);
    private final MergeEngine mergeEngine;
    private Conflict conflict;
    private String newPath;
    private FileEncoding newEncoding;
    private final Object lock = new Object();
    private ProcessRunner mergeRunner;
    private ThreeWayMerge threeWayMerge;
    private ExternalConflictResolver conflictResolver = new ExternalConflictResolver();

    public ExternalConflictResolution(ConflictDescription conflictDescription, String description, String helpText, ConflictResolutionOptions options, ExternalToolset configuredMergeTools) {
        super(conflictDescription, description, helpText, options);
        this.mergeEngine = new MergeEngine(conflictDescription.getWorkspace(), conflictDescription.getWorkspace().getClient(), configuredMergeTools);
    }

    @Override
    public ConflictResolution newForConflictDescription(ConflictDescription conflictDescription) {
        return new ExternalConflictResolution(conflictDescription, this.getDescription(), this.getHelpText(), ConflictResolutionOptions.NONE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewPath(String newPath) {
        Object object = this.lock;
        synchronized (object) {
            this.newPath = newPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncoding(FileEncoding newEncoding) {
        Object object = this.lock;
        synchronized (object) {
            this.newEncoding = newEncoding;
        }
    }

    public void setConflictResolver(ExternalConflictResolver resolver) {
        Check.notNull(resolver, "resolver");
        this.conflictResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConflictResolutionStatus work() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.mergeRunner != null) {
                throw new Exception(Messages.getString("ExternalConflictResolution.AnotherExternalProcessIsResolvingThisConflict"));
            }
            this.conflict = new Conflict(this.getConflictDescription().getConflict());
            this.threeWayMerge = new ThreeWayMerge();
            if (this.newEncoding != null) {
                this.conflict.getResolutionOptions().setEncodingStrategy(ResolutionOptions.EncodingStrategy.OVERRIDE_EXPLICIT, this.newEncoding);
                this.conflict.getResolutionOptions().setAcceptMergeEncoding(this.newEncoding);
            }
            this.mergeRunner = this.mergeEngine.beginExternalMerge(this.conflict, this.threeWayMerge, this, null, null);
            return ConflictResolutionStatus.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mergeRunner == null || this.getStatus() != ConflictResolutionStatus.RUNNING) {
                return;
            }
            this.mergeRunner.interrupt();
        }
        this.setStatus(ConflictResolutionStatus.CANCELLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCompleted(ProcessRunner runner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mergeEngine.endExternalMerge(runner, this.conflict, this.threeWayMerge)) {
                Workspace workspace = this.getConflictDescription().getWorkspace();
                Conflict actualConflict = this.getConflictDescription().getConflict();
                actualConflict.setResolution(Resolution.ACCEPT_MERGE);
                actualConflict.setMergedFileName(this.conflict.getMergedFileName());
                if (this.newPath != null) {
                    actualConflict.getResolutionOptions().setNewPath(this.newPath);
                }
                if (this.conflictResolver.resolveConflict(workspace, actualConflict)) {
                    this.setStatus(ConflictResolutionStatus.SUCCESS);
                } else {
                    actualConflict.getResolutionOptions().setNewPath(null);
                    this.setStatus(ConflictResolutionStatus.CANCELLED);
                }
            } else {
                this.setStatus(ConflictResolutionStatus.CANCELLED);
            }
            this.conflict = null;
            this.mergeRunner = null;
            this.threeWayMerge = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processExecFailed(ProcessRunner runner) {
        Object object = this.lock;
        synchronized (object) {
            String message = runner.getState() == ProcessRunner.ProcessRunnerState.EXEC_FAILED ? MessageFormat.format(Messages.getString("ExternalConflictResolution.ExecutionErrorCheckToolConfigurationFormat"), runner.getExecutionError().getMessage()) : Messages.getString("ExternalConflictResolution.UnknownErrorCheckToolConfiguration");
            this.setErrorMessage(message);
            this.setStatus(ConflictResolutionStatus.FAILED);
            this.conflict = null;
            this.mergeRunner = null;
            this.threeWayMerge = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInterrupted(ProcessRunner runner) {
        Object object = this.lock;
        synchronized (object) {
            this.setErrorMessage(Messages.getString("ExternalConflictResolution.TheExternalMergeProcessWasInterrupted"));
            this.setStatus(ConflictResolutionStatus.FAILED);
        }
    }

    public static class ExternalConflictResolver {
        public boolean resolveConflict(Workspace workspace, Conflict conflict) {
            try {
                workspace.resolveConflict(conflict);
            }
            catch (Exception e) {
                log.error((Object)"Could not resolve conflict", (Throwable)e);
            }
            return false;
        }
    }
}

