/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes;

import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.BooleanFileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.StringPairFileAttribute;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.CollatorFactory;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class FileAttributesCollection
implements Iterable<FileAttribute> {
    private final Map<String, FileAttribute> attributes;
    private static final FileAttributeNameComparator NAME_COMPARATOR = new FileAttributeNameComparator();

    public FileAttributesCollection(FileAttribute[] initialAttributes) {
        Check.notNull(initialAttributes, "initialAttributes");
        this.attributes = new TreeMap<String, FileAttribute>(NAME_COMPARATOR);
        for (FileAttribute attribute2 : initialAttributes) {
            Check.notNull(attribute2, "attribute");
            this.attributes.put(attribute2.getName(), attribute2);
        }
    }

    private FileAttributesCollection(Map<String, FileAttribute> attributes) {
        this.attributes = attributes;
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean containsAttribute(String name) {
        Check.notNullOrEmpty(name, "name");
        return this.attributes.containsKey(name);
    }

    public boolean containsBooleanAttribute(String name) {
        Check.notNullOrEmpty(name, "name");
        FileAttribute attribute2 = this.attributes.get(name);
        return attribute2 != null && attribute2 instanceof BooleanFileAttribute;
    }

    public FileAttribute getFileAttribute(String name) {
        Check.notNullOrEmpty(name, "name");
        return this.attributes.get(name);
    }

    public BooleanFileAttribute getBooleanFileAttribute(String name) {
        Check.notNullOrEmpty(name, "name");
        FileAttribute match = this.attributes.get(name);
        if (match != null && match instanceof BooleanFileAttribute) {
            return (BooleanFileAttribute)match;
        }
        return null;
    }

    public StringPairFileAttribute getStringPairFileAttribute(String name) {
        Check.notNullOrEmpty(name, "name");
        FileAttribute match = this.attributes.get(name);
        if (match != null && match instanceof StringPairFileAttribute) {
            return (StringPairFileAttribute)match;
        }
        return null;
    }

    public FileAttributesCollection mergeWith(FileAttributesCollection other) {
        if (other == null || other.size() == 0) {
            return this;
        }
        TreeMap<String, FileAttribute> merged = new TreeMap<String, FileAttribute>(NAME_COMPARATOR);
        for (FileAttribute attribute2 : this.attributes.values()) {
            merged.put(attribute2.getName(), attribute2);
        }
        for (FileAttribute attribute2 : other) {
            if (merged.containsKey(attribute2.getName())) continue;
            merged.put(attribute2.getName(), attribute2);
        }
        return new FileAttributesCollection(merged);
    }

    @Override
    public Iterator<FileAttribute> iterator() {
        return this.attributes.values().iterator();
    }

    private static final class FileAttributeNameComparator
    implements Comparator<String> {
        private FileAttributeNameComparator() {
        }

        @Override
        public int compare(String one, String two) {
            return CollatorFactory.getCaseSensitiveCollator(Locale.ENGLISH).compare(one, two);
        }
    }
}

