/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.UnableToLoadLocalPropertiesTableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.UnableToLoadLocalVersionTableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.UnableToLoadPendingChangesTableException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.AllTablesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTableHeader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionHeaderTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionPendingChangesHeadersTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionPendingChangesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.PendingChangesHeaderTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.PendingChangesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.Tables;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesLocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTableHeader;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.jni.FileSystemTime;
import com.microsoft.tfs.jni.helpers.FileCopyHelper;
import com.microsoft.tfs.util.Check;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalWorkspaceTransaction
implements Closeable {
    private static final Log log = LogFactory.getLog(LocalWorkspaceTransaction.class);
    private final Workspace workspace;
    private WorkspaceLock workspaceLock;
    private final boolean requestYield;
    private final long creationThreadID;
    private final boolean ownsWorkspaceLock;
    private LocalWorkspaceProperties wp;
    private WorkspaceVersionTable lv;
    private LocalPendingChangesTable pc;
    private WorkspaceVersionTableHeader lvh;
    private LocalPendingChangesTableHeader pch;
    private boolean autoRecover = true;
    private static final boolean ALLOW_CACHED_LOADS;
    private static final String ALLOW_CACHED_LOADS_PROPERTY_NAME = "com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.enablecachedmetadatatableloads";
    private volatile boolean raisePendingChangesChanged;
    private volatile boolean raisePendingChangeCandidatesChanged;
    private static final ThreadLocal<LocalWorkspaceTransaction> current;

    public LocalWorkspaceTransaction(Workspace workspace) {
        this(workspace, null);
    }

    public LocalWorkspaceTransaction(Workspace workspace, boolean requestYield) {
        this(workspace, null, requestYield);
    }

    public LocalWorkspaceTransaction(Workspace workspace, WorkspaceLock workspaceLock) {
        this(workspace, workspaceLock, true);
    }

    public LocalWorkspaceTransaction(Workspace workspace, WorkspaceLock workspaceLock, boolean requestYield) {
        Check.isTrue(WorkspaceLocation.LOCAL == workspace.getLocation(), "Workspace must be a local workspace");
        this.workspace = workspace;
        this.workspaceLock = workspaceLock != null ? workspaceLock : WorkspaceLock.getCurrent();
        this.ownsWorkspaceLock = null == this.workspaceLock;
        this.requestYield = requestYield;
        if (!this.ownsWorkspaceLock) {
            Check.isTrue(this.workspace.equals(this.workspaceLock.getWorkspace()), "this.workspace.equals(this.workspaceLock.getWorkspace())");
            this.workspaceLock.startTransaction();
        }
        Check.isTrue(current.get() == null, "A local workspace transaction is already running on this thread");
        current.set(this);
        this.creationThreadID = Thread.currentThread().getId();
    }

    public void setAllowTxF(boolean allow) {
    }

    public boolean ownsWorkspaceLock() {
        return this.ownsWorkspaceLock;
    }

    public boolean isRaisePendingChangesChanged() {
        return this.raisePendingChangesChanged;
    }

    public void setRaisePendingChangesChanged(boolean value) {
        this.raisePendingChangesChanged = value;
    }

    public boolean isRaisePendingChangeCandidatesChanged() {
        return this.raisePendingChangeCandidatesChanged;
    }

    public void setRaisePendingChangeCandidatesChanged(boolean value) {
        this.raisePendingChangeCandidatesChanged = value;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public static LocalWorkspaceTransaction getCurrent() {
        return current.get();
    }

    public Tables getOpenedTables() {
        Tables toReturn = Tables.NONE;
        if (null != this.wp) {
            toReturn = toReturn.combine(Tables.WORKSPACE_PROPERTIES);
        }
        if (null != this.lv || null != this.lvh) {
            toReturn = toReturn.combine(Tables.LOCAL_VERSION).combine(Tables.LOCAL_VERSION_HEADER);
        }
        if (null != this.pc || null != this.pch) {
            toReturn = toReturn.combine(Tables.PENDING_CHANGES).combine(Tables.PENDING_CHANGES_HEADER);
        }
        return toReturn;
    }

    public WorkspaceLock getWorkspaceLock() {
        return this.workspaceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        boolean raisePendingChangeCandidatesChanged;
        boolean raisePendingChangesChanged;
        block54: {
            block51: {
                Check.isTrue(Thread.currentThread().getId() == this.creationThreadID, "A different thread is disposing a LocalWorkspaceTransaction than the one that created it");
                raisePendingChangesChanged = false;
                raisePendingChangeCandidatesChanged = false;
                try {
                    if (null != this.pc) {
                        Check.isTrue(null == this.pch, "null == pch");
                        if (this.raisePendingChangesChanged && !this.pc.isAborted()) {
                            raisePendingChangesChanged = true;
                        } else if (this.raisePendingChangeCandidatesChanged && !this.pc.isAborted()) {
                            raisePendingChangeCandidatesChanged = true;
                        }
                        this.pc.close();
                        this.workspace.getOfflineCacheData().cacheMetadataTable(this.pc);
                        this.pc = null;
                        break block51;
                    }
                    if (null != this.pch) {
                        this.pch.close();
                        this.workspace.getOfflineCacheData().cacheMetadataTable(this.pch);
                        this.pch = null;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (null != this.lv) {
                            Check.isTrue(null == this.lvh, "null == lvh");
                            this.lv.close();
                            this.workspace.getOfflineCacheData().cacheMetadataTable(this.lv);
                            this.lv = null;
                            throw throwable;
                        }
                        if (null == this.lvh) throw throwable;
                        this.lvh.close();
                        this.workspace.getOfflineCacheData().cacheMetadataTable(this.lvh);
                        this.lvh = null;
                        throw throwable;
                    }
                    finally {
                        try {
                            if (null != this.wp) {
                                this.wp.close();
                                this.workspace.getOfflineCacheData().cacheMetadataTable(this.wp);
                                this.wp = null;
                            }
                        }
                        finally {
                            block53: {
                                try {
                                    if (null == this.workspaceLock) break block53;
                                    if (this.ownsWorkspaceLock) {
                                        this.workspaceLock.close();
                                        this.workspaceLock = null;
                                    } else {
                                        this.workspaceLock.endTransaction();
                                    }
                                }
                                finally {
                                    current.set(null);
                                }
                            }
                        }
                    }
                }
            }
            try {
                if (null != this.lv) {
                    Check.isTrue(null == this.lvh, "null == lvh");
                    this.lv.close();
                    this.workspace.getOfflineCacheData().cacheMetadataTable(this.lv);
                    this.lv = null;
                    break block54;
                }
                if (null != this.lvh) {
                    this.lvh.close();
                    this.workspace.getOfflineCacheData().cacheMetadataTable(this.lvh);
                    this.lvh = null;
                }
            }
            finally {
                try {
                    if (null != this.wp) {
                        this.wp.close();
                        this.workspace.getOfflineCacheData().cacheMetadataTable(this.wp);
                        this.wp = null;
                    }
                }
                finally {
                    block56: {
                        try {
                            if (null == this.workspaceLock) break block56;
                            if (this.ownsWorkspaceLock) {
                                this.workspaceLock.close();
                                this.workspaceLock = null;
                            } else {
                                this.workspaceLock.endTransaction();
                            }
                        }
                        finally {
                            current.set(null);
                        }
                    }
                }
            }
        }
        if (raisePendingChangesChanged) {
            this.workspace.getClient().getEventEngine().firePendingChangesChangedEvent(new WorkspaceEvent(EventSource.newFromHere(), this.workspace, WorkspaceEvent.WorkspaceEventSource.EXTERNAL_SCANNED));
        }
        if (!raisePendingChangeCandidatesChanged) return;
        this.workspace.getClient().getEventEngine().firePendingChangeCandidatesChangedEvent(new WorkspaceEvent(EventSource.newFromHere(), this.workspace, WorkspaceEvent.WorkspaceEventSource.EXTERNAL_SCANNED));
    }

    public void abort() {
        if (null != this.pc) {
            this.pc.setAborted(true);
        }
        if (null != this.lv) {
            this.lv.setAborted(true);
        }
        if (null != this.wp) {
            this.wp.setAborted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WorkspacePropertiesTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES);
        if (null == this.wp || this.wp.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.wp);
            success = true;
        }
        finally {
            if (!success && null != this.wp) {
                this.wp.setAborted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalVersionTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION));
        if (null == this.lv || this.lv.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.lv);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalVersionHeaderTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION_HEADER));
        if (null == this.lvh || this.lvh.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.lvh);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PendingChangesTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION_HEADER).combine(Tables.PENDING_CHANGES));
        if (null == this.pc || this.pc.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.pc);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PendingChangesHeaderTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION_HEADER).combine(Tables.PENDING_CHANGES_HEADER));
        if (null == this.pch || this.pch.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.pch);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WorkspacePropertiesLocalVersionTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION));
        if (null == this.wp || null == this.lv || this.wp.isAborted() || this.lv.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.wp, this.lv);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalVersionPendingChangesTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION).combine(Tables.PENDING_CHANGES));
        if (null == this.lv || null == this.pc || this.lv.isAborted() || this.pc.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.lv, this.pc);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalVersionPendingChangesHeadersTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION_HEADER).combine(Tables.PENDING_CHANGES_HEADER));
        if (null == this.lvh || null == this.pch || this.lvh.isAborted() || this.pch.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.lvh, this.pch);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AllTablesTransaction toExecute) {
        this.acquireTables(Tables.WORKSPACE_PROPERTIES.combine(Tables.LOCAL_VERSION).combine(Tables.PENDING_CHANGES));
        if (null == this.wp || null == this.lv || null == this.pc || this.wp.isAborted() || this.lv.isAborted() || this.pc.isAborted()) {
            throw new IllegalStateException();
        }
        boolean success = false;
        try {
            toExecute.invoke(this.wp, this.lv, this.pc);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    private void acquireTables(Tables toAcquire) {
        LocalMetadataTable cachedTable;
        if (this.ownsWorkspaceLock) {
            Check.isTrue(null == this.workspaceLock, "Execute() may only be called once per instance of LocalWorkspaceTransaction");
            this.workspaceLock = new WorkspaceLock(this.workspace, this.requestYield);
        }
        if (null == this.wp && toAcquire.contains(Tables.WORKSPACE_PROPERTIES)) {
            try {
                Workspace serverWorkspace;
                String wpFullPathWithoutExtension = LocalPath.combine(this.workspace.getLocalMetadataDirectory(), "properties");
                boolean regenerateWorkspaceProperties = false;
                if (this.autoRecover) {
                    regenerateWorkspaceProperties = !this.doAutoRecover(wpFullPathWithoutExtension);
                }
                cachedTable = null;
                if (!regenerateWorkspaceProperties && ALLOW_CACHED_LOADS) {
                    cachedTable = (LocalWorkspaceProperties)this.workspace.getOfflineCacheData().getCachedMetadataTable(LocalWorkspaceProperties.class);
                }
                this.wp = new LocalWorkspaceProperties(wpFullPathWithoutExtension, (LocalWorkspaceProperties)cachedTable);
                if (regenerateWorkspaceProperties && null != (serverWorkspace = this.workspace.getClient().getWebServiceLayer().queryServerWorkspace(this.workspace.getName(), this.workspace.getOwnerName()))) {
                    this.wp.setWorkingFolders(serverWorkspace.getFolders());
                }
            }
            catch (Exception e) {
                throw new UnableToLoadLocalPropertiesTableException(this.workspace.getDisplayName(), e);
            }
        }
        String localVersionTableLocation = null;
        String pendingChangesTableLocation = null;
        if (toAcquire.contains(Tables.LOCAL_VERSION) || toAcquire.contains(Tables.LOCAL_VERSION_HEADER)) {
            localVersionTableLocation = this.wp.getMetadataTableLocation("localversion");
        }
        if (toAcquire.contains(Tables.PENDING_CHANGES) || toAcquire.contains(Tables.PENDING_CHANGES_HEADER)) {
            pendingChangesTableLocation = this.wp.getMetadataTableLocation("pendingchanges");
        }
        if (null == this.lv && toAcquire.contains(Tables.LOCAL_VERSION)) {
            try {
                cachedTable = null;
                if (ALLOW_CACHED_LOADS) {
                    cachedTable = (WorkspaceVersionTable)this.workspace.getOfflineCacheData().getCachedMetadataTable(WorkspaceVersionTable.class);
                }
                this.lv = new WorkspaceVersionTable(localVersionTableLocation, (WorkspaceVersionTable)cachedTable);
            }
            catch (Exception e) {
                throw new UnableToLoadLocalVersionTableException(this.workspace.getDisplayName(), e);
            }
        }
        if (null == this.lvh && toAcquire.contains(Tables.LOCAL_VERSION_HEADER)) {
            try {
                cachedTable = null;
                if (ALLOW_CACHED_LOADS) {
                    cachedTable = LocalWorkspaceTransaction.getBestCachedLoadSource(WorkspaceVersionTable.class, WorkspaceVersionTableHeader.class, this.workspace);
                }
                this.lvh = new WorkspaceVersionTableHeader(localVersionTableLocation, cachedTable);
            }
            catch (Exception e) {
                throw new UnableToLoadLocalVersionTableException(this.workspace.getDisplayName(), e);
            }
        }
        if (null == this.pc && toAcquire.contains(Tables.PENDING_CHANGES)) {
            try {
                cachedTable = null;
                if (ALLOW_CACHED_LOADS) {
                    cachedTable = (LocalPendingChangesTable)this.workspace.getOfflineCacheData().getCachedMetadataTable(LocalPendingChangesTable.class);
                }
                this.pc = new LocalPendingChangesTable(pendingChangesTableLocation, (LocalPendingChangesTable)cachedTable);
            }
            catch (Exception e) {
                throw new UnableToLoadPendingChangesTableException(this.workspace.getDisplayName(), e);
            }
        }
        if (null == this.pch && toAcquire.contains(Tables.PENDING_CHANGES_HEADER)) {
            try {
                cachedTable = null;
                if (ALLOW_CACHED_LOADS) {
                    cachedTable = LocalWorkspaceTransaction.getBestCachedLoadSource(LocalPendingChangesTable.class, LocalPendingChangesTableHeader.class, this.workspace);
                }
                this.pch = new LocalPendingChangesTableHeader(pendingChangesTableLocation, cachedTable);
            }
            catch (Exception e) {
                throw new UnableToLoadPendingChangesTableException(this.workspace.getDisplayName(), e);
            }
        }
    }

    private static LocalMetadataTable getBestCachedLoadSource(Class<? extends LocalMetadataTable> t, Class<? extends LocalMetadataTable> u, Workspace workspace) {
        LocalMetadataTable cachedLoadSourceT = workspace.getOfflineCacheData().getCachedMetadataTable(t);
        LocalMetadataTable cachedLoadSourceU = workspace.getOfflineCacheData().getCachedMetadataTable(u);
        if (null == cachedLoadSourceT && null == cachedLoadSourceU) {
            return null;
        }
        if (null != cachedLoadSourceT && null == cachedLoadSourceU) {
            return cachedLoadSourceT;
        }
        if (null == cachedLoadSourceT && null != cachedLoadSourceU) {
            return cachedLoadSourceU;
        }
        FileSystemTime writeTimeT = cachedLoadSourceT.getSavedAttributes().getModificationTime();
        FileSystemTime writeTimeU = cachedLoadSourceU.getSavedAttributes().getModificationTime();
        if (writeTimeU != null && writeTimeT == null) {
            return cachedLoadSourceU;
        }
        if (writeTimeU != null && writeTimeT != null && writeTimeT.compareTo(writeTimeU) < 0) {
            return cachedLoadSourceU;
        }
        return cachedLoadSourceT;
    }

    public boolean getAutoRecover() {
        return this.autoRecover;
    }

    public void setAutoRecover(boolean value) {
        this.autoRecover = value;
    }

    private boolean doAutoRecover(String wpPathWithoutExtension) {
        String slotOnePath = LocalMetadataTable.getSlotOnePath(wpPathWithoutExtension);
        if (new File(slotOnePath).exists()) {
            return true;
        }
        String slotTwoPath = LocalMetadataTable.getSlotTwoPath(wpPathWithoutExtension);
        if (new File(slotTwoPath).exists()) {
            return true;
        }
        String wpTableName = LocalPath.getFileName(wpPathWithoutExtension);
        try {
            PersistenceStoreProvider provider = this.workspace.getClient().getConnection().getPersistenceStoreProvider();
            WorkspaceInfo wsInfo = Workstation.getCurrent(provider).getLocalWorkspaceInfo(this.workspace.getClient(), this.workspace.getName(), this.workspace.getOwnerName());
            if (null != wsInfo) {
                for (int i = 0; i < BaselineFolder.getPartitioningFolderCount(); ++i) {
                    String tfFolderName = BaselineFolder.getBaselineFolderName();
                    if (0 != i) {
                        tfFolderName = tfFolderName + Integer.toString(i);
                    }
                    for (String mappedPath : wsInfo.getMappedPaths()) {
                        String potentialBaselineFolderName = LocalPath.combine(mappedPath, tfFolderName);
                        String potentialWpPathWithoutExtension = LocalPath.combine(potentialBaselineFolderName, wpTableName);
                        String potentialSlotOnePath = LocalMetadataTable.getSlotOnePath(potentialWpPathWithoutExtension);
                        if (!new File(potentialSlotOnePath).exists()) continue;
                        BaselineFolder.ensureLocalMetadataDirectoryExists(this.workspace);
                        FileCopyHelper.copy(potentialSlotOnePath, slotOnePath);
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            log.trace((Object)"Auto recover failed", (Throwable)ex);
        }
        return false;
    }

    static {
        current = new ThreadLocal();
        String propertyValue = System.getProperty(ALLOW_CACHED_LOADS_PROPERTY_NAME);
        ALLOW_CACHED_LOADS = propertyValue == null || !propertyValue.equalsIgnoreCase("false");
    }
}

