/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.offline;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineChange;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineSynchronizerFilter;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineSynchronizerMethod;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineSynchronizerProvider;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.HashUtils;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OfflineSynchronizer {
    private final Workspace workspace;
    private boolean detectAdded = true;
    private boolean detectDeleted = true;
    private RecursionType recursionType = RecursionType.ONE_LEVEL;
    private final OfflineSynchronizerProvider provider;
    private OfflineSynchronizerFilter filter = new OfflineSynchronizerFilter();
    private OfflineSynchronizerMethod method = OfflineSynchronizerMethod.MD5_HASH;
    private Map<String, byte[]> serverFiles = new HashMap<String, byte[]>();
    private PendingChange[] serverChanges = new PendingChange[0];
    private final List<OfflineChange> offlineChanges = new ArrayList<OfflineChange>();
    private final List<String> excludes = new ArrayList<String>();
    private final TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();

    public OfflineSynchronizer(Workspace workspace, OfflineSynchronizerProvider provider) {
        this(workspace, provider, null);
    }

    public OfflineSynchronizer(Workspace workspace, OfflineSynchronizerProvider provider, OfflineSynchronizerFilter filter) {
        Check.notNull(workspace, "workspace");
        Check.notNull(provider, "provider");
        this.workspace = workspace;
        this.provider = provider;
        if (filter != null) {
            this.filter = filter;
        }
    }

    public void setDetectAdded(boolean detectAdded) {
        this.detectAdded = detectAdded;
    }

    public void setDetectDeleted(boolean detectDeleted) {
        this.detectDeleted = detectDeleted;
    }

    public void setFilter(OfflineSynchronizerFilter filter) {
        this.filter = filter;
    }

    public void setMethod(OfflineSynchronizerMethod method) {
        this.method = method;
    }

    public void setRecursionType(RecursionType recursionType) {
        this.recursionType = recursionType;
    }

    public OfflineChange[] getChanges() {
        return this.offlineChanges.toArray(new OfflineChange[this.offlineChanges.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int detectChanges() throws Exception {
        Check.notNull(this.workspace, "workspace");
        Check.notNull(this.provider, "provider");
        this.offlineChanges.clear();
        this.taskMonitor.begin(Messages.getString("OfflineSynchronizer.DetectingOfflineChanges"), 400);
        try {
            this.getServerState(this.taskMonitor.newSubTaskMonitor(100));
            this.scanLocal(this.taskMonitor.newSubTaskMonitor(100));
            this.taskMonitor.setCurrentWorkDescription(Messages.getString("OfflineSynchronizer.ExaminingLocalFilesystemForDeletions"));
            this.getDeletions();
            this.taskMonitor.worked(100);
            this.taskMonitor.setCurrentWorkDescription(Messages.getString("OfflineSynchronizer.ResolvingConflictingChanges"));
            this.resolveChanges();
            this.taskMonitor.worked(100);
            int n = this.offlineChanges.size();
            return n;
        }
        finally {
            this.taskMonitor.done();
        }
    }

    private List<String> getLocalPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Object[] resources = this.provider.getResources();
        for (int i = 0; i < resources.length; ++i) {
            String resourcePath = this.provider.getLocalPathForResource(resources[i]);
            if (resourcePath == null) continue;
            paths.add(resourcePath);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServerState(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.begin(Messages.getString("OfflineSynchronizer.ExaminingServerState"), 2);
        try {
            taskMonitor.setCurrentWorkDescription(Messages.getString("OfflineSynchronizer.ExaminingServerFileInformation"));
            this.serverFiles = this.getServerFiles();
            taskMonitor.worked(1);
            taskMonitor.setCurrentWorkDescription(Messages.getString("OfflineSynchronizer.ExaminingServerChanges"));
            this.serverChanges = this.getPendingChanges();
            taskMonitor.worked(1);
        }
        finally {
            taskMonitor.done();
        }
    }

    private Map<String, byte[]> getServerFiles() throws Exception {
        if (this.taskMonitor.isCanceled()) {
            throw new CanceledException();
        }
        List<String> queryPaths = this.getLocalPaths();
        HashMap<String, byte[]> localPaths = new HashMap<String, byte[]>();
        ItemSpec[] itemSpecs = new ItemSpec[queryPaths.size()];
        for (int i = 0; i < queryPaths.size(); ++i) {
            String path = queryPaths.get(i);
            itemSpecs[i] = new ItemSpec(LocalPath.canonicalize(path), this.recursionType);
        }
        WorkspaceVersionSpec versionSpec = new WorkspaceVersionSpec(this.workspace);
        ItemSet[] itemSet = this.workspace.getClient().getItems(itemSpecs, (VersionSpec)versionSpec, DeletedState.NON_DELETED, ItemType.ANY, false);
        Check.isTrue(queryPaths.size() == itemSet.length, "queryPaths.size() == itemSet.length");
        for (int i = 0; i < itemSet.length; ++i) {
            String queriedItem = itemSpecs[i].getItem();
            Item[] item = itemSet[i].getItems();
            for (int j = 0; j < item.length; ++j) {
                if (this.taskMonitor.isCanceled()) {
                    throw new CanceledException();
                }
                String mappedPath = this.workspace.getMappedLocalPath(item[j].getServerItem());
                if (mappedPath == null) continue;
                localPaths.put(mappedPath, item[j].getContentHashValue());
                this.addLocalParents(localPaths, queriedItem, mappedPath);
            }
        }
        return localPaths;
    }

    private void addLocalParents(Map<String, byte[]> localPaths, String baseFile, String localFile) {
        Check.notNull(localPaths, "localPaths");
        Check.notNull(baseFile, "baseFile");
        Check.notNull(localFile, "localFile");
        if (LocalPath.equals(baseFile, localFile)) {
            return;
        }
        File parentFile = new File(localFile).getParentFile();
        if (parentFile == null) {
            return;
        }
        String parent = this.canonicalPath(parentFile);
        if (localPaths.containsKey(parent)) {
            return;
        }
        localPaths.put(parent, new byte[0]);
        this.addLocalParents(localPaths, baseFile, parent);
    }

    private PendingChange[] getPendingChanges() {
        if (this.taskMonitor.isCanceled()) {
            throw new CanceledException();
        }
        PendingSet pendingSet = this.workspace.getPendingChanges();
        if (pendingSet != null && pendingSet.getPendingChanges() != null) {
            return pendingSet.getPendingChanges();
        }
        return new PendingChange[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanLocal(TaskMonitor taskMonitor) throws Exception {
        if (taskMonitor.isCanceled()) {
            throw new CanceledException();
        }
        List<String> paths = this.getLocalPaths();
        taskMonitor.begin(Messages.getString("OfflineSynchronizer.ExaminingLocalFilesystem"), paths.size());
        try {
            for (String localPath : paths) {
                taskMonitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("OfflineSynchronizer.ExaminingLocalPathFormat"), localPath));
                File file = new File(localPath);
                this.scanLocal(file, 0);
                taskMonitor.worked(1);
            }
        }
        finally {
            taskMonitor.done();
        }
    }

    private void scanLocal(File file, int depth) throws Exception {
        ItemType serverItemType;
        if (this.taskMonitor.isCanceled()) {
            throw new CanceledException();
        }
        FileSystemUtils util = FileSystemUtils.getInstance();
        FileSystemAttributes attrs = util.getAttributes(file);
        String path = file.getAbsolutePath();
        if (!attrs.isSymbolicLink()) {
            path = this.canonicalPath(file);
        }
        if (this.workspace.getClient().getServiceLevel().getValue() < WebServiceLevel.TFS_2012_2.getValue() && attrs.isSymbolicLink()) {
            this.serverFiles.remove(path);
            return;
        }
        boolean exists = this.serverFiles.containsKey(path);
        byte[] hashCode = this.serverFiles.remove(path);
        ItemType itemType = serverItemType = hashCode == null || hashCode.length == 0 ? ItemType.FOLDER : ItemType.FILE;
        if (!attrs.isSymbolicLink() && !file.exists()) {
            this.serverFiles.put(path, hashCode);
        } else if (file.isFile() || attrs.isSymbolicLink()) {
            OfflineChangeType type = null;
            OfflineChangeType propertyType = null;
            if (!exists && this.detectAdded) {
                type = OfflineChangeType.ADD;
                if (attrs.isSymbolicLink()) {
                    propertyType = OfflineChangeType.SYMLINK;
                } else if (attrs.isExecutable()) {
                    propertyType = OfflineChangeType.EXEC;
                }
            } else if (exists) {
                if (attrs.isSymbolicLink()) {
                    String targetLink = util.getSymbolicLink(file.getPath());
                    byte[] localHashByLink = HashUtils.hashString(targetLink, null, "MD5");
                    if (!Arrays.equals(localHashByLink, hashCode)) {
                        type = OfflineChangeType.EDIT;
                    }
                } else if (this.isChanged(file, hashCode)) {
                    type = OfflineChangeType.EDIT;
                }
                if (this.workspace.getClient().getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                    boolean symlinkOnServer = false;
                    boolean executable = false;
                    ItemSet[] items = this.workspace.getClient().getItems(new ItemSpec[]{new ItemSpec(path, RecursionType.NONE)}, (VersionSpec)LatestVersionSpec.INSTANCE, DeletedState.ANY, ItemType.ANY, GetItemsOptions.NONE, PropertyConstants.QUERY_ALL_PROPERTIES_FILTERS);
                    if (items != null && items.length > 0 && items[0].getItems() != null && items[0].getItems().length > 0) {
                        PropertyValue[] propertyValues = items[0].getItems()[0].getPropertyValues();
                        symlinkOnServer = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(propertyValues, "Microsoft.TeamFoundation.VersionControl.SymbolicLink"));
                        executable = PropertyConstants.EXECUTABLE_ENABLED_VALUE.equals(PropertyUtils.selectMatching(propertyValues, "Microsoft.TeamFoundation.VersionControl.Executable"));
                    }
                    if (symlinkOnServer != attrs.isSymbolicLink()) {
                        propertyType = attrs.isSymbolicLink() ? OfflineChangeType.SYMLINK : OfflineChangeType.NOT_SYMLINK;
                    } else if (!attrs.isSymbolicLink() && executable != attrs.isExecutable()) {
                        propertyType = attrs.isExecutable() ? OfflineChangeType.EXEC : OfflineChangeType.NOT_EXEC;
                    }
                }
            }
            OfflineChange newChange = null;
            if (type != null && this.filter.shouldPend(file, type, serverItemType)) {
                newChange = new OfflineChange(path, type, serverItemType);
                if (propertyType != null) {
                    newChange.addChangeType(propertyType);
                }
            } else if (propertyType != null && this.filter.shouldPend(file, propertyType, serverItemType)) {
                newChange = new OfflineChange(path, propertyType, serverItemType);
            }
            if (newChange != null) {
                this.offlineChanges.add(newChange);
            }
        } else if (file.isDirectory()) {
            if (!exists && this.filter.shouldPend(file, OfflineChangeType.ADD, serverItemType)) {
                this.offlineChanges.add(new OfflineChange(path, OfflineChangeType.ADD, serverItemType));
            }
            if (this.filter.shouldRecurse(file)) {
                if (this.shouldRecurse(file, depth)) {
                    String[] contents = file.list();
                    for (int i = 0; i < contents.length; ++i) {
                        File child = new File(path + File.separatorChar + contents[i]);
                        this.scanLocal(child, depth + 1);
                    }
                }
            } else {
                this.excludes.add(path);
            }
        }
    }

    private boolean shouldRecurse(File directory, int depth) {
        if (depth == 0) {
            return this.recursionType != RecursionType.NONE;
        }
        return this.recursionType == RecursionType.FULL;
    }

    private void getDeletions() {
        if (!this.detectDeleted) {
            return;
        }
        Iterator<String> i = this.serverFiles.keySet().iterator();
        while (i.hasNext()) {
            ItemType serverItemType;
            if (this.taskMonitor.isCanceled()) {
                throw new CanceledException();
            }
            String filename = i.next();
            byte[] hash = this.serverFiles.get(filename);
            ItemType itemType = serverItemType = hash == null || hash.length == 0 ? ItemType.FOLDER : ItemType.FILE;
            if (this.isExcluded(filename) || !this.filter.shouldPend(new File(filename), OfflineChangeType.DELETE, serverItemType)) continue;
            this.offlineChanges.add(new OfflineChange(filename, OfflineChangeType.DELETE, serverItemType));
        }
    }

    private boolean isExcluded(String filename) {
        for (String base : this.excludes) {
            if (!filename.startsWith(base + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    private boolean isChanged(File file, byte[] expectedHash) throws FileNotFoundException, HashUtils.UncheckedNoSuchAlgorithmException, IOException, CanceledException {
        if (file.canWrite()) {
            return true;
        }
        if (this.method == OfflineSynchronizerMethod.MD5_HASH) {
            byte[] actualHash = HashUtils.hashFile(file, "MD5", this.taskMonitor);
            return !Arrays.equals(actualHash, expectedHash);
        }
        return false;
    }

    private void resolveChanges() {
        ArrayList<OfflineChange> undoChanges = new ArrayList<OfflineChange>();
        Iterator<OfflineChange> i = this.offlineChanges.iterator();
        while (i.hasNext()) {
            OfflineChange change = i.next();
            for (int j = 0; j < this.serverChanges.length; ++j) {
                if (this.taskMonitor.isCanceled()) {
                    throw new CanceledException();
                }
                if (this.serverChanges[j].getLocalItem() == null || !LocalPath.equals(this.serverChanges[j].getLocalItem(), change.getLocalPath())) continue;
                ChangeType changeType = this.serverChanges[j].getChangeType();
                if (change.hasChangeType(OfflineChangeType.EDIT) && (changeType.contains(ChangeType.ADD) || changeType.contains(ChangeType.EDIT))) {
                    i.remove();
                    continue;
                }
                if (change.hasChangeType(OfflineChangeType.DELETE) && changeType.contains(ChangeType.ADD)) {
                    change.setChangeType(OfflineChangeType.UNDO);
                    continue;
                }
                if (change.hasChangeType(OfflineChangeType.DELETE) && changeType.contains(ChangeType.EDIT)) {
                    change.setChangeType(OfflineChangeType.UNDO);
                    change.addChangeType(OfflineChangeType.DELETE);
                    continue;
                }
                if (change.hasChangeType(OfflineChangeType.ADD) && changeType.contains(ChangeType.DELETE)) {
                    change.setChangeType(OfflineChangeType.UNDO);
                    change.addChangeType(OfflineChangeType.EDIT);
                    continue;
                }
                if (!change.hasChangeType(OfflineChangeType.DELETE) || !changeType.contains(ChangeType.RENAME)) continue;
                change.setChangeType(OfflineChangeType.UNDO);
                String sourceLocalPath = this.workspace.getMappedLocalPath(this.serverChanges[j].getSourceServerItem());
                if (sourceLocalPath == null) continue;
                File sourceLocalFile = new File(sourceLocalPath);
                if (!sourceLocalFile.exists()) {
                    if (this.isExcluded(sourceLocalPath) || !this.filter.shouldPend(sourceLocalFile, OfflineChangeType.DELETE, change.getServerItemType())) continue;
                    change.addChangeType(OfflineChangeType.DELETE);
                    change.setSourceLocalPath(sourceLocalPath);
                    continue;
                }
                undoChanges.add(new OfflineChange(sourceLocalPath, OfflineChangeType.ADD, change.getServerItemType()));
                if (this.isExcluded(sourceLocalPath) || !this.filter.shouldPend(sourceLocalFile, OfflineChangeType.EDIT, null)) continue;
                change.addChangeType(OfflineChangeType.EDIT);
                change.setSourceLocalPath(sourceLocalPath);
            }
        }
        this.offlineChanges.removeAll(undoChanges);
    }

    private String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }
}

