/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.MultipleWorkspacesFoundException;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RuntimeWorkspaceCache {
    private final Map<String, WeakReference<Workspace>> m_cache = new TreeMap<String, WeakReference<Workspace>>(String.CASE_INSENSITIVE_ORDER);
    private final VersionControlClient client;
    private final ReadWriteLock m_rwLock = new ReentrantReadWriteLock();

    public RuntimeWorkspaceCache(VersionControlClient client) {
        Check.notNull(client, "client");
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllWorkspaces() {
        this.m_rwLock.readLock().lock();
        try {
            for (Map.Entry<String, WeakReference<Workspace>> entry : this.m_cache.entrySet()) {
                Workspace workspace = (Workspace)entry.getValue().get();
                if (null == workspace) continue;
                workspace.invalidate();
            }
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    public Workspace tryGetWorkspace(WorkspaceInfo workspaceInfo) {
        Check.notNull(workspaceInfo, "workspaceInfo");
        this.checkServerGUID(workspaceInfo.getServerGUID(), "workspaceInfo");
        return this.tryGetWorkspace(workspaceInfo.getName(), workspaceInfo.getOwnerName());
    }

    public Workspace tryGetWorkspace(String workspaceName, String workspaceOwner) {
        Check.notNullOrEmpty(workspaceName, "workspaceName");
        Check.notNullOrEmpty(workspaceOwner, "workspaceOwner");
        List<Workspace> matchingWorkspaces = this.tryGetWorkspacesHelper(workspaceName, workspaceOwner);
        if (matchingWorkspaces.size() > 1) {
            ArrayList<String> specs = new ArrayList<String>(matchingWorkspaces.size());
            for (Workspace workspace : matchingWorkspaces) {
                specs.add(workspace.getQualifiedName());
            }
            throw new MultipleWorkspacesFoundException(workspaceName, workspaceOwner, specs);
        }
        if (matchingWorkspaces.size() > 0) {
            return matchingWorkspaces.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getWorkspace(WorkspaceInfo workspaceInfo) {
        Check.notNull(workspaceInfo, "workspaceInfo");
        Workspace cachedWorkspace = this.tryGetWorkspace(workspaceInfo);
        if (null == cachedWorkspace) {
            Workspace constructedWorkspace = this.constructWorkspaceFromWorkspaceInfo(workspaceInfo);
            String cacheKey = this.getCacheKey(workspaceInfo);
            this.m_rwLock.writeLock().lock();
            try {
                AtomicBoolean deadReference = new AtomicBoolean();
                cachedWorkspace = this.tryGetWorkspaceHelper(cacheKey, deadReference);
                if (null == cachedWorkspace) {
                    cachedWorkspace = constructedWorkspace;
                    this.m_cache.put(cacheKey, new WeakReference<Workspace>(cachedWorkspace));
                }
            }
            finally {
                this.m_rwLock.writeLock().unlock();
            }
        }
        return cachedWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace cacheWorkspace(Workspace workspace) {
        Check.notNull(workspace, "workspace");
        this.checkServerGUID(workspace.getClient().getServerGUID(), "workspace");
        Workspace cachedWorkspace = this.tryGetWorkspace(workspace.getName(), workspace.getOwnerName());
        if (null == cachedWorkspace) {
            String cacheKey = this.getCacheKey(workspace);
            this.m_rwLock.writeLock().lock();
            try {
                AtomicBoolean deadReference = new AtomicBoolean();
                cachedWorkspace = this.tryGetWorkspaceHelper(cacheKey, deadReference);
                if (null == cachedWorkspace) {
                    cachedWorkspace = workspace;
                    this.m_cache.put(cacheKey, new WeakReference<Workspace>(cachedWorkspace));
                }
            }
            finally {
                this.m_rwLock.writeLock().unlock();
            }
        }
        Check.notNull(cachedWorkspace, "cachedWorkspace");
        if (workspace != cachedWorkspace) {
            cachedWorkspace.updateFromWorkspace(workspace);
        }
        return cachedWorkspace;
    }

    public Workspace[] cacheWorkspaces(Workspace[] workspaces) {
        Check.notNull(workspaces, "workspaces");
        Workspace[] toReturn = new Workspace[workspaces.length];
        for (int i = 0; i < workspaces.length; ++i) {
            toReturn[i] = this.cacheWorkspace(workspaces[i]);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkspace(Workspace existingWorkspace, Workspace newWorkspace) {
        Check.notNull(existingWorkspace, "existingWorkspace");
        Check.notNull(newWorkspace, "newWorkspace");
        this.m_rwLock.writeLock().lock();
        try {
            String oldCacheKey = this.getCacheKey(existingWorkspace);
            existingWorkspace.updateFromWorkspace(newWorkspace);
            this.m_cache.remove(oldCacheKey);
            this.m_cache.put(this.getCacheKey(newWorkspace), new WeakReference<Workspace>(existingWorkspace));
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    private Workspace constructWorkspaceFromWorkspaceInfo(WorkspaceInfo workspaceInfo) {
        Workspace constructedWorkspace = new Workspace(this.client, workspaceInfo.getName(), workspaceInfo.getOwnerName(), workspaceInfo.getOwnerDisplayName(), workspaceInfo.getOwnerAliases(), workspaceInfo.getComment(), workspaceInfo.getSecurityToken(), null, workspaceInfo.getComputer(), workspaceInfo.getLocation(), WorkspacePermissions.NONE_OR_NOT_SUPPORTED, null, workspaceInfo.getOptions());
        constructedWorkspace.invalidate();
        return constructedWorkspace;
    }

    private void checkServerGUID(GUID toCheck, String propertyName) {
        if (null == toCheck || !toCheck.equals(this.client.getServerGUID())) {
            throw new IllegalArgumentException(Messages.getString("RuntimeWorkspaceCache.VersionControlClientMismatch"));
        }
    }

    private String getCacheKey(Workspace workspace) {
        return new WorkspaceSpec(workspace.getName(), workspace.getOwnerName()).toString();
    }

    private String getCacheKey(WorkspaceInfo workspaceInfo) {
        return new WorkspaceSpec(workspaceInfo.getName(), workspaceInfo.getOwnerName()).toString();
    }

    private Workspace tryGetWorkspaceHelper(String cacheKey, AtomicBoolean deadReference) {
        deadReference.set(false);
        WeakReference<Workspace> cachedWorkspaceWeakRef = this.m_cache.get(cacheKey);
        if (cachedWorkspaceWeakRef != null) {
            Workspace cachedWorkspace = (Workspace)cachedWorkspaceWeakRef.get();
            if (null != cachedWorkspace && !cachedWorkspace.isDeleted()) {
                return cachedWorkspace;
            }
            deadReference.set(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Workspace> tryGetWorkspacesHelper(String workspaceName, String workspaceOwner) {
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        ArrayList<String> deadReferenceCacheKeys = new ArrayList<String>();
        this.m_rwLock.readLock().lock();
        try {
            for (Map.Entry<String, WeakReference<Workspace>> entry : this.m_cache.entrySet()) {
                Workspace workspace = (Workspace)entry.getValue().get();
                if (null != workspace && !workspace.isDeleted()) {
                    if (null != workspaceName && (!Workspace.matchName(workspaceName, workspace.getName()) || !workspace.ownerNameMatches(workspaceOwner))) continue;
                    workspaces.add(workspace);
                    continue;
                }
                deadReferenceCacheKeys.add(entry.getKey());
            }
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
        if (deadReferenceCacheKeys.size() > 0) {
            this.m_rwLock.writeLock().lock();
            try {
                for (String deadReferenceCacheKey : deadReferenceCacheKeys) {
                    this.removeDeadReference(deadReferenceCacheKey);
                }
            }
            finally {
                this.m_rwLock.writeLock().unlock();
            }
        }
        return workspaces;
    }

    private boolean removeDeadReference(String cacheKey) {
        AtomicBoolean deadReference = new AtomicBoolean();
        boolean removed = false;
        if (null == this.tryGetWorkspaceHelper(cacheKey, deadReference) && deadReference.get()) {
            removed = this.m_cache.remove(cacheKey) != null;
            Check.isTrue(removed, "removed");
        }
        return removed;
    }

    public List<Workspace> getWorkspaces() {
        return this.tryGetWorkspacesHelper(null, null);
    }
}

