/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.webservices.PropertyTypeNotSupportedException;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationPropertyValidationException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class PropertyValidation {
    public static final int MAX_PROPERTY_NAME_LENGTH_IN_CHARS = 400;
    public static final int MAX_BYTE_VALUE_SIZE = 0x800000;
    public static final int MAX_STRING_VALUE_LENGTH = 0x400000;
    public static final Calendar MIN_ALLOWED_DATE_TIME = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    public static final Calendar MAX_ALLOWED_DATE_TIME;
    public static double MIN_NEGATIVE;
    public static double MAX_NEGATIVE;
    public static double MIN_POSITIVE;
    public static double MAX_POSITIVE;

    public static void validatePropertyName(String propertyName) throws TeamFoundationPropertyValidationException {
        PropertyValidation.validatePropertyString(propertyName, 400, "propertyName");
        if (Character.isWhitespace(propertyName.charAt(0)) || Character.isWhitespace(propertyName.charAt(propertyName.length() - 1))) {
            throw new TeamFoundationPropertyValidationException(propertyName, MessageFormat.format(Messages.getString("PropertyValidation.InvalidPropertyNameFormat"), propertyName));
        }
    }

    public static void validatePropertyValue(String propertyName, Object value) throws TeamFoundationPropertyValidationException {
        if (null != value) {
            if (value instanceof byte[]) {
                PropertyValidation.validateByteArray(propertyName, (byte[])value);
            } else {
                if (value.getClass().isArray()) {
                    throw new PropertyTypeNotSupportedException(propertyName, value.getClass());
                }
                if (value instanceof Integer) {
                    PropertyValidation.validateInteger(propertyName, (Integer)value);
                } else if (value instanceof Double) {
                    PropertyValidation.validateDouble(propertyName, (Double)value);
                } else if (value instanceof Calendar) {
                    PropertyValidation.validateCalendar(propertyName, (Calendar)value);
                } else if (value instanceof String) {
                    PropertyValidation.validateStringValue(propertyName, (String)value);
                } else {
                    PropertyValidation.validateStringValue(propertyName, value.toString());
                }
            }
        }
    }

    private static void validateStringValue(String propertyName, String propertyValue) {
        if (propertyValue.length() > 0x400000) {
            throw new TeamFoundationPropertyValidationException("value", MessageFormat.format(Messages.getString("PropertyValidation.InvalidPropertyValueSizeFormat"), propertyName, String.class.getName(), 0x400000));
        }
        PropertyUtils.checkForInvalidCharacters(propertyValue, "value");
    }

    private static void validateByteArray(String propertyName, byte[] propertyValue) {
        if (propertyValue.length > 0x800000) {
            throw new TeamFoundationPropertyValidationException("value", MessageFormat.format(Messages.getString("PropertyValidation.InvalidPropertyValueSizeFormat"), propertyName, propertyValue.getClass().getName(), 0x800000));
        }
    }

    private static void validateCalendar(String propertyName, Calendar propertyValue) {
        Calendar copy = (Calendar)propertyValue.clone();
        if (!copy.equals(DotNETDate.MIN_CALENDAR) && !copy.equals(DotNETDate.MAX_CALENDAR) && copy.getTime().getTimezoneOffset() != 0) {
            copy.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        PropertyValidation.checkRange(copy, MIN_ALLOWED_DATE_TIME, MAX_ALLOWED_DATE_TIME, propertyName, "value");
    }

    private static void validateDouble(String propertyName, Double propertyValue) {
        if (Double.isInfinite(propertyValue) || Double.isNaN(propertyValue)) {
            throw new TeamFoundationPropertyValidationException("value", MessageFormat.format(Messages.getString("PropertyValidation.DoubleValueOutOfRangeFormat"), propertyName, propertyValue));
        }
        if (propertyValue < MIN_NEGATIVE || propertyValue < 0.0 && propertyValue > MAX_NEGATIVE || propertyValue > MAX_POSITIVE || propertyValue > 0.0 && propertyValue < MIN_POSITIVE) {
            throw new TeamFoundationPropertyValidationException("value", MessageFormat.format(Messages.getString("PropertyValidation.DoubleValueOutOfRangeFormat"), propertyName, propertyValue));
        }
    }

    private static void validateInteger(String propertyName, int propertyValue) {
    }

    private static void validatePropertyString(String propertyString, int maxSize, String argumentName) {
        Check.notNullOrEmpty(propertyString, argumentName);
        if (propertyString.length() > maxSize) {
            throw new TeamFoundationPropertyValidationException(argumentName, MessageFormat.format(Messages.getString("PropertyValidation.PropertyArgumentExceededMaximumSizeAllowedFormat"), argumentName, maxSize));
        }
        PropertyUtils.checkForInvalidCharacters(propertyString, argumentName);
    }

    public static void checkPropertyLength(String propertyValue, Boolean allowNull, int minLength, int maxLength, String propertyName, Class<? extends Object> containerType, String topLevelParamName) {
        boolean valueIsInvalid = false;
        if (propertyValue == null) {
            if (!allowNull.booleanValue()) {
                valueIsInvalid = true;
            }
        } else if (propertyValue.length() < minLength || propertyValue.length() > maxLength) {
            valueIsInvalid = true;
        }
        if (valueIsInvalid) {
            if (propertyValue == null) {
                propertyValue = "";
            }
            if (allowNull.booleanValue()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("PropertyValidation.InvalidStringPropertyValueNullAllowedFormat"), propertyValue, propertyName, containerType.getName(), minLength, maxLength));
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("PropertyValidation.InvalidStringPropertyValueNullForbiddenFormat"), propertyValue, propertyName, containerType.getClass().getName(), minLength, maxLength));
        }
    }

    public static <T extends Comparable<T>> void checkRange(T propertyValue, T minValue, T maxValue, String propertyName, Class<? extends Object> containerType, String topLevelParamName) {
        if (propertyValue.compareTo(minValue) < 0 || propertyValue.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("PropertyValidation.ValueTypeOutOfRangeFormat"), propertyValue, propertyName, containerType.getClass().getName(), minValue, maxValue));
        }
    }

    private static <T extends Comparable<T>> void checkRange(T propertyValue, T minValue, T maxValue, String propertyName, String topLevelParamName) {
        if (propertyValue.compareTo(minValue) < 0 || propertyValue.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("PropertyValidation.PropertyValueOutOfRangeFormat"), propertyValue, propertyName, minValue, maxValue));
        }
    }

    public static void validatePropertyFilter(String propertyNameFilter) {
        PropertyValidation.validatePropertyString(propertyNameFilter, 400, "propertyNameFilter");
    }

    static {
        MIN_ALLOWED_DATE_TIME.set(1753, 0, 1, 0, 0, 0);
        MAX_ALLOWED_DATE_TIME = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        MAX_ALLOWED_DATE_TIME.setTimeInMillis(DotNETDate.MAX_CALENDAR.getTimeInMillis());
        MAX_ALLOWED_DATE_TIME.add(5, -1);
        MIN_NEGATIVE = Double.parseDouble("-1.79E+308");
        MAX_NEGATIVE = Double.parseDouble("-2.23E-308");
        MIN_POSITIVE = Double.parseDouble("2.23E-308");
        MAX_POSITIVE = Double.parseDouble("1.79E+308");
    }
}

