/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.WorkItemStateListener;
import com.microsoft.tfs.core.clients.workitem.events.WorkItemSaveEvent;
import com.microsoft.tfs.core.clients.workitem.exceptions.DeniedOrNotExistException;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnableToSaveException;
import com.microsoft.tfs.core.clients.workitem.fields.FieldCollection;
import com.microsoft.tfs.core.clients.workitem.files.AttachmentCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemStateListenerSupport;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldModificationType;
import com.microsoft.tfs.core.clients.workitem.internal.files.AttachmentCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.GetResultsRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RevisionsRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParser;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.WorkItemFilesRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.WorkItemRelationsRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.WorkItemTextsRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IRuleTarget;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IRuleTargetField;
import com.microsoft.tfs.core.clients.workitem.internal.rules.RuleEngine;
import com.microsoft.tfs.core.clients.workitem.internal.update.WorkItemUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.internal.wittype.WorkItemTypeImpl;
import com.microsoft.tfs.core.clients.workitem.link.LinkCollection;
import com.microsoft.tfs.core.clients.workitem.link.LinkFactory;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.revision.RevisionCollection;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementDeserializable;
import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.StaxAnyContentType;
import java.text.MessageFormat;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap_GetWorkItemResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap_GetWorkItemResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap_GetWorkItemResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WorkItemImpl
implements WorkItem,
IRuleTarget {
    private static final Log log = LogFactory.getLog(WorkItemImpl.class);
    private boolean open = false;
    private boolean currentDirtyState = false;
    private final WITContext witContext;
    private final FieldCollectionImpl fieldCollection;
    private final LinkCollectionImpl linkCollection;
    private final AttachmentCollectionImpl attachmentCollection;
    private final RevisionCollectionImpl revisionCollection;
    private int tempId = 0;
    private static int TEMPID = 0;
    private static Object TEMPIDLOCK = new Object();
    private final WorkItemStateListenerSupport stateListeners = new WorkItemStateListenerSupport(this);

    public WorkItemImpl(WITContext witContext) {
        this.witContext = witContext;
        this.linkCollection = new LinkCollectionImpl(this);
        this.attachmentCollection = new AttachmentCollectionImpl(this);
        this.revisionCollection = new RevisionCollectionImpl();
        this.fieldCollection = new FieldCollectionImpl(this, witContext);
        this.open = false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WorkItemImpl) {
            WorkItemImpl other = (WorkItemImpl)obj;
            if (this.fieldCollection.getID() == 0) {
                return this == other;
            }
            return this.fieldCollection.getID() == other.fieldCollection.getID();
        }
        return false;
    }

    public int hashCode() {
        return this.fieldCollection.getID();
    }

    public String toString() {
        String messageFormat = Messages.getString("WorkItemImpl.WorkItemIdWithHexFormat");
        return MessageFormat.format(messageFormat, this.getID(), Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public WorkItemClient getClient() {
        return this.witContext.getClient();
    }

    @Override
    public void open() {
        if (this.open) {
            return;
        }
        if (!this.fieldCollection.hasField(-3)) {
            throw new IllegalStateException(Messages.getString("WorkItemImpl.AttemptToOpenItemWithNoIdField"));
        }
        if (this.fieldCollection.getFieldInternal(-3).getValue() == null) {
            throw new IllegalStateException(Messages.getString("WorkItemImpl.AttemptToOpenItemWithNoIdValue"));
        }
        int id = this.fieldCollection.getID();
        if (id != 0) {
            DOMAnyContentType domContent;
            String dbStamp;
            AnyContentType metadata;
            ElementDeserializable response;
            log.info((Object)MessageFormat.format("Opening work item {0} from server", Integer.toString(id)));
            if (this.witContext.isVersion2()) {
                response = this.witContext.getProxy().getWorkItem(id, 0, 0, null, true, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
                metadata = ((_ClientService2Soap_GetWorkItemResponse)response).getMetadata();
                dbStamp = ((_ClientService2Soap_GetWorkItemResponse)response).getDbStamp();
                domContent = (DOMAnyContentType)((_ClientService2Soap_GetWorkItemResponse)response).getWorkItem();
            } else if (this.witContext.isVersion3()) {
                response = this.witContext.getProxy3().getWorkItem(id, 0, 0, null, true, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
                metadata = ((_ClientService3Soap_GetWorkItemResponse)response).getMetadata();
                dbStamp = ((_ClientService3Soap_GetWorkItemResponse)response).getDbStamp();
                domContent = (DOMAnyContentType)((_ClientService3Soap_GetWorkItemResponse)response).getWorkItem();
            } else {
                response = this.witContext.getProxy5().getWorkItem(id, 0, 0, null, true, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
                metadata = ((_ClientService5Soap_GetWorkItemResponse)response).getMetadata();
                dbStamp = ((_ClientService5Soap_GetWorkItemResponse)response).getDbStamp();
                domContent = (DOMAnyContentType)((_ClientService5Soap_GetWorkItemResponse)response).getWorkItem();
            }
            this.witContext.getMetadataUpdateHandler().updateMetadata(metadata, dbStamp);
            metadata.dispose();
            this.fieldCollection.reset();
            this.fieldCollection.ensureAllFieldsInWIPhysicalType();
            this.linkCollection.internalClear();
            this.attachmentCollection.internalClear();
            this.revisionCollection.internalClear();
            Element workItemInfoTable = domContent.getElements()[0];
            Element revisionsTable = domContent.getElements()[1];
            Element textsTable = domContent.getElements()[3];
            Element filesTable = domContent.getElements()[4];
            Element relationsTable = domContent.getElements()[5];
            RowSetParser parser = new RowSetParser();
            GetResultsRowSetHandler getTableHandler = new GetResultsRowSetHandler(this);
            parser.parse(workItemInfoTable, (RowSetParseHandler)getTableHandler);
            if (!getTableHandler.parsedRow()) {
                throw new DeniedOrNotExistException(MessageFormat.format(Messages.getString("WorkItemImpl.DoesNotExistOrAccessDeniedFormat"), Integer.toString(this.getID())));
            }
            parser.parse(revisionsTable, (RowSetParseHandler)new RevisionsRowSetHandler(this));
            parser.parse(textsTable, (RowSetParseHandler)new WorkItemTextsRowSetHandler(this, this.witContext.getMetadata()));
            parser.parse(filesTable, (RowSetParseHandler)new WorkItemFilesRowSetHandler(this, this.witContext.getMetadata()));
            parser.parse(relationsTable, (RowSetParseHandler)new WorkItemRelationsRowSetHandler(this, this.witContext.getMetadata()));
        }
        this.runRulesForOpen();
        this.open = true;
    }

    @Override
    public void save() throws UnableToSaveException {
        if (!this.open) {
            throw new IllegalStateException(Messages.getString("WorkItemImpl.CannotSave"));
        }
        this.internalSave();
        this.fireStateListenersIfNeeded();
        this.stateListeners.fireSaved();
        this.getClient().getEventEngine().fireWorkItemSaveEvent(new WorkItemSaveEvent(EventSource.newFromHere(), this));
    }

    @Override
    public String getNextState(String action) {
        return this.getTypeInternal().getNextState((String)this.getFields().getField("System.State").getValue(), action);
    }

    @Override
    public Project getProject() {
        return this.getType().getProject();
    }

    @Override
    public WorkItemType getType() {
        int areaId = this.getFields().getAreaID();
        String workItemTypeName = this.getFields().getWorkItemType();
        NodeImpl node = this.witContext.getRootNode().findNodeDownwards(areaId);
        node = node.getProjectNodeParent();
        String projectName = node.getName();
        return this.getClient().getProjects().get(projectName).getWorkItemTypes().get(workItemTypeName);
    }

    @Override
    public void reset() {
        boolean newlyCreated;
        if (!this.open) {
            return;
        }
        WorkItemType type = null;
        boolean bl = newlyCreated = this.fieldCollection.getID() == 0;
        if (newlyCreated) {
            type = this.getType();
        }
        this.fieldCollection.reset();
        this.linkCollection.reset();
        this.attachmentCollection.reset();
        if (newlyCreated) {
            this.witContext.initNewWorkItem(this, type);
        }
        this.runRulesForOpen();
        this.fireStateListenersIfNeeded();
    }

    @Override
    public void syncToLatest() {
        if (this.fieldCollection.getID() == 0) {
            throw new UnsupportedOperationException(Messages.getString("WorkItemImpl.CannotPerformOperationItemNotSaved"));
        }
        this.open = false;
        this.open();
        this.fireStateListenersIfNeeded();
        this.stateListeners.fireSynchedToLatest();
        this.fieldCollection.fireFieldChangeListeners();
    }

    @Override
    public boolean isValid() {
        return this.fieldCollection.isValid();
    }

    @Override
    public boolean isDirty() {
        return this.fieldCollection.isDirty() || this.linkCollection.isDirty() || this.attachmentCollection.isDirty();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public AttachmentCollection getAttachments() {
        return this.attachmentCollection;
    }

    @Override
    public FieldCollection getFields() {
        return this.fieldCollection;
    }

    @Override
    public RevisionCollection getRevisions() {
        return this.revisionCollection;
    }

    @Override
    public LinkCollection getLinks() {
        return this.linkCollection;
    }

    @Override
    public void addWorkItemStateListener(WorkItemStateListener listener) {
        this.stateListeners.addListener(listener);
    }

    @Override
    public void removeWorkItemStateListener(WorkItemStateListener listener) {
        this.stateListeners.removeListener(listener);
    }

    @Override
    public String getURI() {
        ArtifactID id = new ArtifactID("WorkItemTracking", "WorkItem", String.valueOf(this.getFields().getID()));
        return id.encodeURI();
    }

    @Override
    public String getTitle() {
        return (String)this.getFields().getField("System.Title").getValue();
    }

    @Override
    public void setTitle(String title) {
        this.getFields().getField("System.Title").setValue(title);
    }

    @Override
    public WorkItem copy() {
        return this.copy(this.getType());
    }

    @Override
    public WorkItem copy(WorkItemType targetType) {
        if (!this.open) {
            throw new UnsupportedOperationException(Messages.getString("WorkItemImpl.CopyNotSupportedWhenItemNotOpen"));
        }
        WorkItemImpl newWorkItem = new WorkItemImpl(this.witContext);
        this.witContext.initNewWorkItem(newWorkItem, targetType);
        this.fieldCollection.copy(newWorkItem.fieldCollection);
        this.linkCollection.copy(newWorkItem.linkCollection);
        if (this.getFields().getID() != 0) {
            RelatedLink relatedLink = LinkFactory.newRelatedLink(newWorkItem, this, null, false);
            newWorkItem.linkCollection.add(relatedLink);
        }
        newWorkItem.open();
        return newWorkItem;
    }

    private void runRulesForOpen() {
        RuleEngine engine = new RuleEngine(this, this.witContext);
        engine.open();
        String changedBy = this.getContext().getCurrentUserDisplayName();
        this.getFieldsInternal().getFieldInternal(9).setValue((Object)changedBy, FieldModificationType.INTERNAL_MODEL);
    }

    public TFSTeamProjectCollection getConnection() {
        return this.witContext.getConnection();
    }

    public WorkItemTypeImpl getTypeInternal() {
        return (WorkItemTypeImpl)this.getType();
    }

    public WITContext getContext() {
        return this.witContext;
    }

    @Override
    public int getID() {
        return this.fieldCollection.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTemporaryID() {
        if (this.tempId == 0) {
            Object object = TEMPIDLOCK;
            synchronized (object) {
                this.tempId = --TEMPID;
            }
        }
        return this.tempId;
    }

    private void internalSave() throws UnableToSaveException {
        this.attachmentCollection.preSave();
        int id = this.getID();
        if (id == 0) {
            log.info((Object)MessageFormat.format("Creating new work item of type {0}", this.getType().getName()));
        } else {
            log.info((Object)MessageFormat.format("Updating work item {0}", Integer.toString(this.getID())));
        }
        WorkItemUpdatePackage updatePackage = new WorkItemUpdatePackage(this, this.witContext);
        updatePackage.update();
        RevisionImpl newRevision = RevisionImpl.createFromFieldCollection(this.fieldCollection, this.witContext, this.revisionCollection.size(), this.revisionCollection);
        this.revisionCollection.addRevisionToEnd(newRevision);
        this.fieldCollection.resetAfterUpdate();
        this.linkCollection.update();
        this.attachmentCollection.update();
        RuleEngine engine = new RuleEngine(this, this.witContext);
        engine.open();
        this.fireStateListenersIfNeeded();
    }

    public AttachmentCollectionImpl getAttachmentsInternal() {
        return this.attachmentCollection;
    }

    public FieldCollectionImpl getFieldsInternal() {
        return this.fieldCollection;
    }

    public LinkCollectionImpl getLinksInternal() {
        return this.linkCollection;
    }

    public RevisionCollectionImpl getRevisionsInternal() {
        return this.revisionCollection;
    }

    public void fireStateListenersIfNeeded() {
        boolean newDirtyState = this.isDirty();
        if (this.currentDirtyState != newDirtyState) {
            this.currentDirtyState = newDirtyState;
            this.stateListeners.fireDirtyStateChanged(newDirtyState);
        }
        this.stateListeners.fireValidStateChanged(this.isValid());
    }

    public String getUpdateXMLForDebugging() {
        return new WorkItemUpdatePackage(this, this.witContext).getUpdateXML();
    }

    @Override
    public int getAreaID() {
        return this.fieldCollection.getAreaID();
    }

    @Override
    public IRuleTargetField getRuleTargetField(int fieldId) {
        return this.fieldCollection.getFieldInternal(fieldId);
    }
}

