/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.node;

import java.text.MessageFormat;

public class NodePathUtils {
    private static final String PATH_SEPARATOR = "\\";
    private static final String PATH_SEPARATOR_REGEX = "\\\\";

    public static String[] splitPathIntoSegments(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        path = path.trim();
        while (path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        while (path.endsWith(PATH_SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        String[] segments = path.split(PATH_SEPARATOR_REGEX);
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = segments[i].trim();
        }
        return segments;
    }

    public static String createPathFromSegments(String[] segments, int beginIndex) {
        if (segments == null) {
            throw new IllegalArgumentException("segments must not be null");
        }
        if (beginIndex < 0 || beginIndex >= segments.length) {
            throw new IllegalArgumentException(MessageFormat.format("beginIndex {0} is out of range (0,{1})", Integer.toString(beginIndex), Integer.toString(segments.length)));
        }
        StringBuffer sb = new StringBuffer();
        int endIndex = segments.length;
        for (int i = beginIndex; i < endIndex; ++i) {
            sb.append(segments[i] == null ? "" : segments[i]);
            if (i >= endIndex - 1) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }
}

