/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.link;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemLinkTypeMetadata;
import com.microsoft.tfs.core.clients.workitem.link.Topology;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;

public class WorkItemLinkType {
    private final WITContext witContext;
    private final WorkItemLinkTypeMetadata linkType;
    private final int rules;
    private final String referenceName;
    private final boolean isDeleted = false;
    private final WorkItemLinkTypeEnd forwardEnd;
    private final WorkItemLinkTypeEnd reverseEnd;

    public WorkItemLinkType(WITContext witContext, WorkItemLinkTypeMetadata linkType) {
        this.witContext = witContext;
        this.linkType = linkType;
        this.referenceName = this.linkType.getReferenceName();
        this.rules = this.linkType.getRules();
        this.forwardEnd = new WorkItemLinkTypeEnd(this, linkType.getForwardName(), linkType.getForwardID());
        if (this.isDirectional()) {
            this.reverseEnd = new WorkItemLinkTypeEnd(this, linkType.getReverseName(), linkType.getReverseID());
            this.reverseEnd.setOppositeEnd(this.forwardEnd);
            this.forwardEnd.setOppositeEnd(this.reverseEnd);
        } else {
            this.forwardEnd.setOppositeEnd(this.forwardEnd);
            this.reverseEnd = this.forwardEnd;
        }
    }

    public WITContext getWITContext() {
        return this.witContext;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public boolean isDeleted() {
        return false;
    }

    public WorkItemLinkTypeEnd getForwardEnd() {
        return this.forwardEnd;
    }

    public WorkItemLinkTypeEnd getReverseEnd() {
        return this.reverseEnd;
    }

    public boolean isDirectional() {
        return (this.rules & 4) == 4;
    }

    public boolean isNonCircular() {
        return (this.rules & 8) == 8;
    }

    public boolean isOneToMany() {
        return (this.rules & 0x10) == 16;
    }

    public boolean isActive() {
        return (this.rules & 0x20) == 0;
    }

    public boolean canDelete() {
        return (this.rules & 1) == 0;
    }

    public boolean canEdit() {
        return (this.rules & 2) == 0;
    }

    public Topology getLinkTopology() {
        return Topology.getTopology(this.rules);
    }
}

