/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db;

import com.microsoft.tfs.core.internal.db.DBException;
import com.microsoft.tfs.core.internal.db.DBSpecificOperations;
import com.microsoft.tfs.core.internal.db.DBStatement;
import com.microsoft.tfs.core.internal.db.HSQLOperations;
import com.microsoft.tfs.core.internal.db.MSSQLOperations;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;

public class DBConnection {
    private final Connection connection;
    private final String driverClass;
    private DBSpecificOperations dbSpecificOperations;

    public DBConnection(Connection connection, String driverClass) {
        this.connection = connection;
        this.driverClass = driverClass;
        if (driverClass.equals("org.hsqldb.jdbcDriver")) {
            this.dbSpecificOperations = new HSQLOperations(this);
        } else if (driverClass.equals("net.sourceforge.jtds.jdbc.Driver")) {
            this.dbSpecificOperations = new MSSQLOperations(this);
        } else {
            throw new IllegalArgumentException(MessageFormat.format("unknown driver class [{0}]", driverClass));
        }
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public DBStatement createStatement(String sql) {
        return new DBStatement(this.connection, sql);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public DBSpecificOperations getDBSpecificOperations() {
        return this.dbSpecificOperations;
    }
}

