/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.pendingcheckin;

import com.microsoft.tfs.core.checkinpolicies.PolicyContext;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluationCancelledException;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluator;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluatorState;
import com.microsoft.tfs.core.checkinpolicies.PolicyFailure;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckin;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinPolicies;
import com.microsoft.tfs.util.Check;

public class StandardPendingCheckinPolicies
implements PendingCheckinPolicies {
    private final PolicyEvaluator evaluator;

    public StandardPendingCheckinPolicies(PendingCheckin pendingCheckin, VersionControlClient client, PolicyEvaluator evaluator) {
        Check.notNull(pendingCheckin, "pendingCheckin");
        Check.notNull(client, "client");
        this.evaluator = evaluator;
        if (this.evaluator != null) {
            this.evaluator.setPendingCheckin(pendingCheckin);
        }
    }

    @Override
    public PolicyFailure[] evaluate(PolicyContext policyContext) throws PolicyEvaluationCancelledException {
        Check.notNull(policyContext, "policyContext");
        if (this.evaluator == null) {
            return new PolicyFailure[0];
        }
        return this.evaluator.evaluate(policyContext);
    }

    @Override
    public PolicyEvaluatorState getPolicyEvaluatorState() {
        if (this.evaluator == null) {
            return PolicyEvaluatorState.POLICIES_LOAD_ERROR;
        }
        return this.evaluator.getPolicyEvaluatorState();
    }
}

