/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BitField
implements Serializable {
    private final int flags;
    private static final Map PER_CLASS_DATA = new HashMap();

    protected BitField(int flags) {
        this.flags = flags;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.flags == ((BitField)obj).flags;
    }

    public final int hashCode() {
        return this.flags;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        buffer.append(name);
        buffer.append(" (" + this.flags + "): ");
        String[] stringValues = this.toStringValues(this.flags, this.getClass());
        for (int i = 0; i < stringValues.length; ++i) {
            buffer.append(stringValues[i]);
            if (i >= stringValues.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public final boolean isEmpty() {
        return this.flags == 0;
    }

    public final String[] toStringValues() {
        return this.toStringValues(this.flags, this.getClass());
    }

    public final int toIntFlags() {
        return this.flags;
    }

    protected final boolean containsAllInternal(BitField other) {
        Check.notNull(other, "other");
        return (this.flags & other.flags) == other.flags;
    }

    protected final boolean containsInternal(BitField other) {
        return this.containsAllInternal(other);
    }

    protected final boolean containsAnyInternal(BitField other) {
        Check.notNull(other, "other");
        return (this.flags & other.flags) != 0;
    }

    protected final int removeInternal(BitField other) {
        Check.notNull(other, "other");
        return this.flags & ~other.flags;
    }

    protected final int retainInternal(BitField other) {
        Check.notNull(other, "other");
        return this.flags & other.flags;
    }

    protected final int combineInternal(BitField other) {
        Check.notNull(other, "other");
        return this.flags | other.flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] toFullStringValues() {
        int i;
        IntFlagStringValuePair[] normalValues;
        IntFlagStringValuePair[] specialValues;
        BitFieldStringData classData;
        Map map = PER_CLASS_DATA;
        synchronized (map) {
            classData = (BitFieldStringData)PER_CLASS_DATA.get(this.getClass());
        }
        if (classData == null) {
            return null;
        }
        List list = classData.specialValues;
        synchronized (list) {
            specialValues = classData.specialValues.toArray(new IntFlagStringValuePair[classData.specialValues.size()]);
        }
        List list2 = classData.normalValues;
        synchronized (list2) {
            normalValues = classData.normalValues.toArray(new IntFlagStringValuePair[classData.normalValues.size()]);
        }
        ArrayList<String> values = new ArrayList<String>();
        boolean foundExactSpecialValue = false;
        for (i = 0; i < specialValues.length; ++i) {
            if (this.flags == specialValues[i].flag) {
                values.clear();
                values.add(specialValues[i].value);
                foundExactSpecialValue = true;
                break;
            }
            if (specialValues[i].flag == 0 || (this.flags & specialValues[i].flag) != specialValues[i].flag) continue;
            values.add(specialValues[i].value);
        }
        if (!foundExactSpecialValue) {
            for (i = 0; i < normalValues.length; ++i) {
                if ((this.flags & normalValues[i].flag) == 0) continue;
                values.add(normalValues[i].value);
            }
        }
        return values.toArray(new String[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] toStringValues(int flags, Class key) {
        IntFlagStringValuePair[] normalValues;
        IntFlagStringValuePair[] specialValues;
        BitFieldStringData classData;
        Map map = PER_CLASS_DATA;
        synchronized (map) {
            classData = (BitFieldStringData)PER_CLASS_DATA.get(key);
        }
        if (classData == null) {
            return null;
        }
        List list = classData.specialValues;
        synchronized (list) {
            specialValues = classData.specialValues.toArray(new IntFlagStringValuePair[classData.specialValues.size()]);
        }
        for (int i = 0; i < specialValues.length; ++i) {
            if (specialValues[i].flag != flags) continue;
            return new String[]{specialValues[i].value};
        }
        List list2 = classData.normalValues;
        synchronized (list2) {
            normalValues = classData.normalValues.toArray(new IntFlagStringValuePair[classData.normalValues.size()]);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < normalValues.length; ++i) {
            if ((flags & normalValues[i].flag) == 0) continue;
            values.add(normalValues[i].value);
        }
        return values.toArray(new String[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int fromStringValues(String[] strings, Class key) {
        IntFlagStringValuePair[] normalValues;
        IntFlagStringValuePair[] specialValues;
        BitFieldStringData classData;
        if (strings.length == 0) {
            return 0;
        }
        Map map = PER_CLASS_DATA;
        synchronized (map) {
            classData = (BitFieldStringData)PER_CLASS_DATA.get(key);
        }
        if (classData == null) {
            return 0;
        }
        int flags = 0;
        List list = classData.specialValues;
        synchronized (list) {
            specialValues = classData.specialValues.toArray(new IntFlagStringValuePair[classData.specialValues.size()]);
        }
        for (int i = 0; i < strings.length; ++i) {
            for (int j = 0; j < specialValues.length; ++j) {
                if (!specialValues[j].value.equals(strings[i])) continue;
                flags |= specialValues[j].flag;
            }
        }
        List j = classData.normalValues;
        synchronized (j) {
            normalValues = classData.normalValues.toArray(new IntFlagStringValuePair[classData.normalValues.size()]);
        }
        for (int i = 0; i < strings.length; ++i) {
            for (int j2 = 0; j2 < normalValues.length; ++j2) {
                if (!normalValues[j2].value.equals(strings[i])) continue;
                flags |= normalValues[j2].flag;
            }
        }
        return flags;
    }

    protected static int combine(BitField[] instances) {
        Check.notNull(instances, "instances");
        int flags = 0;
        for (int i = 0; i < instances.length; ++i) {
            if (instances[i] == null) {
                throw new IllegalArgumentException("array element " + i + " was null");
            }
            flags |= instances[i].flags;
        }
        return flags;
    }

    protected static void registerStringValue(Class key, int flagValue, String stringValue) {
        BitField.registerStringValue(key, flagValue, stringValue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerStringValue(Class key, int flagValue, String stringValue, boolean forceSpecial) {
        boolean specialValue;
        BitFieldStringData classData;
        Check.notNull(key, "key");
        Check.notNull(stringValue, "stringValue");
        IntFlagStringValuePair pair = new IntFlagStringValuePair(flagValue, stringValue);
        Map map = PER_CLASS_DATA;
        synchronized (map) {
            classData = (BitFieldStringData)PER_CLASS_DATA.get(key);
            if (classData == null) {
                classData = new BitFieldStringData();
                PER_CLASS_DATA.put(key, classData);
            }
        }
        boolean bl = specialValue = forceSpecial || flagValue == 0 || BitField.bitCount(flagValue) > 1;
        if (specialValue) {
            List list = classData.specialValues;
            synchronized (list) {
                classData.specialValues.add(pair);
            }
        }
        List list = classData.normalValues;
        synchronized (list) {
            classData.normalValues.add(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCombinedSpecialFlags() {
        IntFlagStringValuePair[] specialValues;
        BitFieldStringData classData;
        Map map = PER_CLASS_DATA;
        synchronized (map) {
            classData = (BitFieldStringData)PER_CLASS_DATA.get(this.getClass());
        }
        if (classData == null) {
            return 0;
        }
        List list = classData.specialValues;
        synchronized (list) {
            specialValues = classData.specialValues.toArray(new IntFlagStringValuePair[classData.specialValues.size()]);
        }
        int specialFlags = 0;
        for (int j = 0; j < specialValues.length; ++j) {
            if ((this.flags & specialValues[j].flag) != specialValues[j].flag) continue;
            specialFlags |= specialValues[j].flag;
        }
        return specialFlags;
    }

    private static int bitCount(int flagValue) {
        int count = 0;
        while (flagValue != 0) {
            flagValue &= flagValue - 1;
            ++count;
        }
        return count;
    }

    private static class IntFlagStringValuePair {
        public final int flag;
        public final String value;

        public IntFlagStringValuePair(int flag, String value) {
            this.flag = flag;
            this.value = value;
        }
    }

    private static class BitFieldStringData {
        public final List specialValues = new ArrayList();
        public final List normalValues = new ArrayList();

        private BitFieldStringData() {
        }
    }
}

