/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkMatrix;
import org.conqat.lib.simulink.model.SimulinkMatrixFactory;
import org.conqat.lib.simulink.model.SimulinkResolvedInformation;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class SimulinkResolvedDimensions
extends SimulinkResolvedInformation {
    private static final long serialVersionUID = 1L;

    public void setInformationForBlock(SimulinkBlock block, SimulinkMatrix matrix) {
        String dimension = matrix.toDimensionFormat();
        super.setOutputInformationForBlock(block, dimension);
    }

    public void setInformationForBlock(SimulinkBlock block, String portIndex, SimulinkMatrix matrix) {
        String dimension = matrix.toDimensionFormat();
        super.setOutputInformationForBlock(block, portIndex, dimension);
    }

    public String getDimensionality(SimulinkBlock block, String index) {
        return super.getResolvedOutputInformationForBlock(block, index);
    }

    public Set<SimulinkMatrix> getDimensionalityForAllPorts(SimulinkBlock block) {
        return super.getResolvedInformationForAllOutports(block).stream().map(SimulinkMatrixFactory::createMatrixFromDimensions).collect(Collectors.toSet());
    }

    public Set<SimulinkMatrix> getInputDimensionalities(SimulinkBlock block) {
        return this.getInputInformation(block).stream().map(SimulinkMatrixFactory::createMatrixFromDimensions).collect(Collectors.toSet());
    }

    public List<SimulinkMatrix> getInputDimensionalitiesAsList(SimulinkBlock block) {
        return this.getInputInformationAsList(block).stream().map(SimulinkMatrixFactory::createMatrixFromDimensions).collect(Collectors.toList());
    }

    public SimulinkMatrix getInputDimensionality(SimulinkBlock block, String portNumber) {
        return SimulinkMatrixFactory.createMatrixFromDimensions(this.getInputInformation(block, portNumber));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String fieldSeparator = "\t";
        builder.append("block").append(fieldSeparator);
        builder.append("dimension").append(StringUtils.LINE_SEPARATOR);
        for (Map.Entry entry : this.resolvedInformation.entrySet()) {
            builder.append((String)entry.getKey()).append(fieldSeparator);
            builder.append((String)entry.getValue()).append(StringUtils.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public @Nullable SimulinkMatrix getAnyOutputDimensionality(SimulinkBlock block) {
        return this.getDimensionalityForAllPorts(block).stream().findFirst().orElse(null);
    }
}

