/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Point;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.PortLayoutData;
import org.jspecify.annotations.Nullable;

public class SimulinkPortUIData {
    private static final String PORT_ARROW_SIZE_PROPERTY = "portArrowSize";
    private static final String BLOCK_PROPERTY = "block";
    private static final String LAYOUT_DATA_PROPERTY = "layoutData";
    private static final String LABEL_DATA_PROPERTY = "labelData";
    private static final String IS_CONNECTED_PROPERTY = "isConnected";
    private static final String ARROW_TIP_PROPERTY = "arrowTip";
    @JsonProperty(value="portArrowSize")
    private final int portArrowSize = 4;
    @JsonProperty(value="block")
    private final String block;
    @JsonProperty(value="layoutData")
    private final PortLayoutData layoutData;
    @JsonProperty(value="labelData")
    private final @Nullable LabelLayoutData labelData;
    @JsonProperty(value="isConnected")
    private final boolean isConnected;
    @JsonProperty(value="arrowTip")
    private final Point arrowTip;

    @JsonCreator
    public SimulinkPortUIData(@JsonProperty(value="block") String block, @JsonProperty(value="layoutData") PortLayoutData layoutData, @JsonProperty(value="labelData") @Nullable LabelLayoutData labelData, @JsonProperty(value="isConnected") boolean isConnected, @JsonProperty(value="arrowTip") Point arrowTip) {
        this.block = block;
        this.layoutData = layoutData;
        this.labelData = labelData;
        this.isConnected = isConnected;
        this.arrowTip = arrowTip;
    }

    public SimulinkPortUIData(SimulinkPortBase port) {
        this.block = port.getBlock().getName();
        this.layoutData = port.obtainLayoutData();
        this.labelData = port.obtainLabelData();
        this.isConnected = port.isConnected();
        Point position = this.layoutData.getPosition();
        if (port instanceof SimulinkOutPort) {
            switch ((int)this.layoutData.getDirection()) {
                case 270: {
                    this.arrowTip = new Point(position.x, position.y + 4 + 1);
                    break;
                }
                case 180: {
                    this.arrowTip = new Point(position.x - 5, position.y);
                    break;
                }
                case 90: {
                    this.arrowTip = new Point(position.x, position.y - 5);
                    break;
                }
                default: {
                    this.arrowTip = new Point(position.x + 4 + 1, position.y);
                    break;
                }
            }
        } else {
            this.arrowTip = new Point(position);
        }
    }

    public String getBlock() {
        return this.block;
    }

    public PortLayoutData getLayoutData() {
        return this.layoutData;
    }

    public LabelLayoutData getLabelData() {
        return this.labelData;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public Point getArrowTip() {
        return this.arrowTip;
    }
}

