/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import java.net.ProxySelector;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.model.TrustManagerParameters;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;
import org.sonarsource.sonarlint.core.http.ApacheHttpClientAdapter;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.http.RedirectInterceptor;

public class HttpClientProvider {
    private final CloseableHttpAsyncClient sharedClient;

    public static HttpClientProvider forTesting() {
        return new HttpClientProvider("SonarLint tests", null, null, ProxySelector.getDefault(), (CredentialsProvider)new BasicCredentialsProvider());
    }

    public HttpClientProvider(String userAgent, @Nullable Path sonarlintUserHome, @Nullable Predicate<TrustManagerParameters> trustManagerParametersPredicate, ProxySelector proxySelector, CredentialsProvider proxyCredentialsProvider) {
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withDefaultTrustMaterial().withSystemTrustMaterial();
        Optional<Path> sonarlintUserHomeOpt = Optional.ofNullable(sonarlintUserHome);
        HttpClientProvider.configureKeyStore(sslFactoryBuilder, sonarlintUserHomeOpt);
        HttpClientProvider.configureTrustStore(trustManagerParametersPredicate, sslFactoryBuilder, sonarlintUserHomeOpt);
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        HttpClientProvider.getTimeoutFromSystemProp("sonarlint.http.connectTimeout").ifPresent(arg_0 -> ((ConnectionConfig.Builder)connectionConfigBuilder).setConnectTimeout(arg_0));
        HttpClientProvider.getTimeoutFromSystemProp("sonarlint.http.socketTimeout").ifPresent(arg_0 -> ((ConnectionConfig.Builder)connectionConfigBuilder).setSocketTimeout(arg_0));
        PoolingAsyncClientConnectionManager asyncConnectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)new DefaultClientTlsStrategy(sslFactoryBuilder.build().getSslContext())).setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_1).build()).setDefaultConnectionConfig(connectionConfigBuilder.build()).build();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        HttpClientProvider.getTimeoutFromSystemProp("sonarlint.http.connectionRequestTimeout").ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectionRequestTimeout(arg_0));
        HttpClientProvider.getTimeoutFromSystemProp("sonarlint.http.responseTimeout").ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setResponseTimeout(arg_0));
        this.sharedClient = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)asyncConnectionManager).addResponseInterceptorFirst((HttpResponseInterceptor)new RedirectInterceptor()).setUserAgent(userAgent).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(proxySelector)).setDefaultCredentialsProvider(proxyCredentialsProvider).setDefaultRequestConfig(requestConfigBuilder.build()).build();
        this.sharedClient.start();
    }

    private static void configureTrustStore(@Nullable Predicate<TrustManagerParameters> trustManagerParametersPredicate, SSLFactory.Builder sslFactoryBuilder, Optional<Path> sonarlintUserHomeOpt) {
        Path truststorePath;
        if (trustManagerParametersPredicate != null && (truststorePath = Optional.ofNullable(System.getProperty("sonarlint.ssl.trustStorePath")).map(x$0 -> Paths.get(x$0, new String[0])).orElse(sonarlintUserHomeOpt.map(p -> p.resolve("ssl/truststore.p12")).orElse(null))) != null) {
            char[] trustStorePwd = System.getProperty("sonarlint.ssl.trustStorePassword", "sonarlint").toCharArray();
            String trustStoreType = System.getProperty("sonarlint.ssl.trustStoreType", "PKCS12");
            sslFactoryBuilder.withInflatableTrustMaterial(truststorePath, trustStorePwd, trustStoreType, trustManagerParametersPredicate);
        }
    }

    private static void configureKeyStore(SSLFactory.Builder sslFactoryBuilder, Optional<Path> sonarlintUserHomeOpt) {
        Path keystorePath = Optional.ofNullable(System.getProperty("sonarlint.ssl.keyStorePath")).map(x$0 -> Paths.get(x$0, new String[0])).orElse(sonarlintUserHomeOpt.map(p -> p.resolve("ssl/keystore.p12")).orElse(null));
        if (keystorePath != null && Files.exists(keystorePath, new LinkOption[0])) {
            char[] keyStorePwd = System.getProperty("sonarlint.ssl.keyStorePassword", "sonarlint").toCharArray();
            String keyStoreType = System.getProperty("sonarlint.ssl.keyStoreType", "PKCS12");
            sslFactoryBuilder.withIdentityMaterial(keystorePath, keyStorePwd, keyStoreType);
        }
    }

    private static Optional<Timeout> getTimeoutFromSystemProp(String key) {
        return Optional.ofNullable(System.getProperty(key)).map(s -> {
            try {
                return Duration.ofMinutes(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return Duration.parse(s);
            }
        }).map(d -> Timeout.of((long)d.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public HttpClient getHttpClient() {
        return new ApacheHttpClientAdapter(this.sharedClient, null, null);
    }

    public HttpClient getHttpClientWithPreemptiveAuth(String usernameOrToken, @Nullable String password) {
        return new ApacheHttpClientAdapter(this.sharedClient, usernameOrToken, password);
    }

    @PreDestroy
    public void close() {
        this.sharedClient.close(CloseMode.IMMEDIATE);
    }
}

