/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.sonar.api.utils.Version;

public class ApiVersions {
    static final String SONAR_PLUGIN_API_VERSION_FILE_PATH = "/sonar-api-version.txt";
    private static final String SONARLINT_PLUGIN_API_VERSION_FILE_PATH = "/sonarlint-api-version.txt";

    private ApiVersions() {
    }

    public static Version loadSonarPluginApiVersion() {
        return ApiVersions.loadVersion(SONAR_PLUGIN_API_VERSION_FILE_PATH);
    }

    public static Version loadSonarLintPluginApiVersion() {
        return ApiVersions.loadVersion(SONARLINT_PLUGIN_API_VERSION_FILE_PATH);
    }

    private static Version loadVersion(String versionFilePath) {
        return ApiVersions.loadVersion(ApiVersions.class.getResource(versionFilePath), versionFilePath);
    }

    static Version loadVersion(URL versionFileURL, String versionFilePath) {
        Scanner scanner = new Scanner(versionFileURL.openStream(), StandardCharsets.UTF_8.name());
        try {
            String versionInFile = scanner.nextLine();
            Version version = Version.parse(versionInFile);
            scanner.close();
            return version;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not load " + versionFilePath + " from classpath", e);
            }
        }
    }
}

