/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.RandomAccess;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.SequencedSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ISortableData;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.ListMapCollector;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SortableDataUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableNavigableMap;
import org.conqat.lib.commons.collections.UnmodifiableNavigableSet;
import org.conqat.lib.commons.collections.UnmodifiableSequencedCollection;
import org.conqat.lib.commons.collections.UnmodifiableSequencedMap;
import org.conqat.lib.commons.collections.UnmodifiableSequencedSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedMap;
import org.conqat.lib.commons.collections.UnmodifiableSortedSet;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CollectionUtils {
    private static final UnmodifiableList<?> EMPTY_LIST = CollectionUtils.asUnmodifiable(Collections.emptyList());
    private static final UnmodifiableMap<?, ?> EMPTY_MAP = CollectionUtils.asUnmodifiable(Collections.emptyMap());
    private static final UnmodifiableSet<?> EMPTY_SET = CollectionUtils.asUnmodifiable(Collections.emptySet());
    public static final Character MULTI_VALUE_DELIMITER = Character.valueOf(',');
    private static final String CONNECTOR_CONFIG_MULTI_VALUE_INPUT_LINE_COMMENT_PREFIX = "##";

    @SafeVarargs
    public static <T> HashSet<T> asHashSet(T ... elements) {
        HashSet result = new HashSet(elements.length);
        Collections.addAll(result, elements);
        return result;
    }

    @SafeVarargs
    public static <K, V> UnmodifiableMap<K, V> asMap(Pair<K, V> ... pairs) {
        return CollectionUtils.asMap(new HashMap(), pairs);
    }

    @SafeVarargs
    public static <K, V> UnmodifiableMap<K, V> asMap(Map<K, V> baseMap, Pair<K, V> ... pairs) {
        for (Pair<K, V> pair : pairs) {
            baseMap.put(pair.getFirst(), pair.getSecond());
        }
        return CollectionUtils.asUnmodifiable(baseMap);
    }

    @SafeVarargs
    public static <T> UnmodifiableSet<T> asUnmodifiableHashSet(T ... elements) {
        return CollectionUtils.asUnmodifiable(CollectionUtils.asHashSet(elements));
    }

    public static <T> UnmodifiableCollection<T> asUnmodifiable(Collection<T> c) {
        return UnmodifiableCollection.of(c);
    }

    public static <T> UnmodifiableList<T> asUnmodifiable(List<T> l) {
        return UnmodifiableList.of(l);
    }

    public static <S, T> UnmodifiableMap<S, T> asUnmodifiable(Map<S, T> m) {
        return UnmodifiableMap.of(m);
    }

    public static <T> UnmodifiableSet<T> asUnmodifiable(Set<T> s) {
        return UnmodifiableSet.of(s);
    }

    public static <S, T> UnmodifiableSortedMap<S, T> asUnmodifiable(SortedMap<S, T> m) {
        return UnmodifiableSortedMap.of(m);
    }

    public static <T> UnmodifiableSortedSet<T> asUnmodifiable(SortedSet<T> s) {
        return UnmodifiableSortedSet.of(s);
    }

    public static <K, V> UnmodifiableNavigableMap<K, V> asUnmodifiable(NavigableMap<K, V> m) {
        return UnmodifiableNavigableMap.of(m);
    }

    public static <T> UnmodifiableNavigableSet<T> asUnmodifiable(NavigableSet<T> s) {
        return UnmodifiableNavigableSet.of(s);
    }

    public static <T> UnmodifiableSequencedCollection<T> asUnmodifiable(SequencedCollection<T> c) {
        return UnmodifiableSequencedCollection.of(c);
    }

    public static <K, V> UnmodifiableSequencedMap<K, V> asUnmodifiable(SequencedMap<K, V> m) {
        return UnmodifiableSequencedMap.of(m);
    }

    public static <T> UnmodifiableSequencedSet<T> asUnmodifiable(SequencedSet<T> s) {
        return UnmodifiableSequencedSet.of(s);
    }

    public static <T> UnmodifiableList<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <S, T> UnmodifiableMap<S, T> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> UnmodifiableSet<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T extends Comparable<? super T>> ArrayList<T> sort(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list);
        return list;
    }

    public static <T> ArrayList<T> reverse(Collection<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    public static <T> void circularShiftRight(List<T> list) {
        if (list.size() <= 1) {
            return;
        }
        if (list instanceof LinkedList) {
            list.addFirst(list.removeLast());
        } else {
            T last = list.getLast();
            ListIterator<T> iter = list.listIterator();
            while (iter.hasNext()) {
                T next = iter.next();
                iter.set(last);
                last = next;
            }
        }
    }

    public static <T> Set<T> getDuplicates(List<T> values) {
        HashSet<T> duplicates = new HashSet<T>();
        HashSet<T> temp = new HashSet<T>();
        for (T key : values) {
            if (temp.add(key)) continue;
            duplicates.add(key);
        }
        return duplicates;
    }

    public static <T, R> List<R> map(Collection<T> list, Function<? super T, ? extends R> mapper) {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T entry : list) {
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <T, R> Set<R> mapToSet(Collection<T> list, Function<? super T, ? extends R> mapper) {
        HashSet<R> result = new HashSet<R>();
        for (T entry : list) {
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <K1, V1, K2, V2> Map<K2, V2> map(Map<K1, V1> map, Function<K1, ? extends K2> keyMapper, Function<V1, ? extends V2> valueMapper) {
        HashMap result = HashMap.newHashMap(map.size());
        map.forEach((key, value) -> result.put(keyMapper.apply(key), valueMapper.apply(value)));
        return result;
    }

    public static <T, R> List<R> map(T[] array, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.map(Arrays.asList(array), mapper);
    }

    public static <T, R> List<R> mapDistinct(Collection<T> list, Function<? super T, ? extends R> mapper) {
        HashSet<R> encounteredItems = new HashSet<R>();
        ArrayList<R> result = new ArrayList<R>();
        for (T entry : list) {
            R resultItem = mapper.apply(entry);
            if (!encounteredItems.add(resultItem)) continue;
            result.add(resultItem);
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> mapWithException(Collection<T> list, FunctionWithException<? super T, ? extends R, ? extends E> mapper) throws E {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T entry : list) {
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> mapWithException(T[] array, FunctionWithException<? super T, ? extends R, ? extends E> mapper) throws E {
        return CollectionUtils.mapWithException(Arrays.asList(array), mapper);
    }

    public static <T> ArrayList<T> getIndices(List<T> list, List<Integer> indices) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (int index : indices) {
            filteredList.add(list.get(index));
        }
        return filteredList;
    }

    public static <T> List<T> returnListWithoutGivenIndices(List<T> elements, Set<Integer> indices) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < elements.size(); ++i) {
            if (indices.contains(i)) continue;
            result.add(elements.get(i));
        }
        return result;
    }

    public static List<Integer> getNullIndices(List<@Nullable ?> list) {
        ArrayList<Integer> nullIndices = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null) continue;
            nullIndices.add(i);
        }
        return nullIndices;
    }

    public static boolean isValidIndex(int index, List<?> list) {
        return index >= 0 && index < list.size();
    }

    public static <T> void removeAll(Set<T> set, List<T> itemsToBeRemoved) {
        if (itemsToBeRemoved.size() >= set.size()) {
            itemsToBeRemoved.forEach(set::remove);
        } else {
            set.removeAll(itemsToBeRemoved);
        }
    }

    public static <K, V> @NonNull Map<K, V> copyWithEntriesRemoved(Map<K, V> map, Set<K> keysToRemove) {
        return map.entrySet().stream().filter(entry -> !keysToRemove.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V1, V2, VR> Map<K, @NonNull VR> merge(Map<K, @Nullable V1> map1, Map<K, @Nullable V2> map2, BiFunction<@Nullable V1, @Nullable V2, @Nullable VR> mergeFunction) {
        HashMap result = new HashMap();
        Sets.SetView keys = Sets.union(map1.keySet(), map2.keySet());
        for (Object key : keys) {
            VR value = mergeFunction.apply(map1.get(key), map2.get(key));
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static <K, V, E extends Exception> V computeIfAbsentWithException(Map<K, V> map, K key, FunctionWithException<? super K, ? extends V, E> mappingFunction) throws E {
        return map.computeIfAbsent((K)key, CollectionUtils.asSneakyFunction(mappingFunction));
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable t) throws T {
        throw t;
    }

    public static <K, V, E extends Exception> Function<K, V> asSneakyFunction(FunctionWithException<K, V, E> functionWithException) {
        return value -> {
            try {
                return functionWithException.apply(value);
            }
            catch (Exception e) {
                throw CollectionUtils.sneakyThrow(e);
            }
        };
    }

    public static <K, E extends Exception> Consumer<K> asSneakyConsumer(ConsumerWithException<K, E> consumerWithExceptionn) {
        return value -> {
            try {
                consumerWithExceptionn.accept(value);
            }
            catch (Exception e) {
                throw CollectionUtils.sneakyThrow(e);
            }
        };
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<? super T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T entry : collection) {
            if (!filter.test(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> filterWithException(Collection<T> collection, FunctionWithException<? super T, Boolean, E> filter) throws E {
        ArrayList<T> result = new ArrayList<T>();
        for (T entry : collection) {
            if (!filter.apply(entry).booleanValue()) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> T[] filterArray(T[] inputArray, Predicate<T> predicate) {
        if (inputArray == null || inputArray.length == 0) {
            return inputArray;
        }
        Object[] tempStorage = (Object[])Array.newInstance(inputArray.getClass().getComponentType(), inputArray.length);
        int count = 0;
        for (T element : inputArray) {
            boolean satisfiesPredicate = predicate.test(element);
            if (!satisfiesPredicate) continue;
            tempStorage[count++] = element;
        }
        Object[] filteredArray = (Object[])Array.newInstance(inputArray.getClass().getComponentType(), count);
        System.arraycopy(tempStorage, 0, filteredArray, 0, count);
        return filteredArray;
    }

    public static <T> Set<T> filterToSet(Collection<T> collection, Predicate<? super T> filter) {
        return CollectionUtils.filterToSet(collection, filter, HashSet::new);
    }

    public static <T> Set<T> filterToSet(Collection<T> collection, Predicate<? super T> filter, Supplier<Set<T>> addToSet) {
        Set<T> result = addToSet.get();
        for (T entry : collection) {
            if (!filter.test(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T, R> List<R> filterAndMap(Collection<T> list, Predicate<? super T> filter, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.filterAndMapWithException(list, filter::test, mapper::apply);
    }

    public static <T, R, X1 extends Exception, X2 extends Exception> List<R> filterAndMapWithException(Collection<T> list, PredicateWithException<? super T, X1> filter, FunctionWithException<? super T, ? extends R, X2> mapper) throws X1, X2 {
        ArrayList<R> result = new ArrayList<R>();
        for (T entry : list) {
            if (!filter.test(entry)) continue;
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <T> List<T> remove(List<T> list, int index) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(index);
        return result;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T extends Comparable<? super T>> UnmodifiableList<T> asSortedUnmodifiableList(Collection<T> collection) {
        return CollectionUtils.asUnmodifiable(CollectionUtils.sort(collection));
    }

    public static <T> @Nullable T getAny(@NonNull Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, collection.size());
        return collection.toArray(result);
    }

    public static <T> T[] copyArray(T[] original) {
        return Arrays.copyOf(original, original.length);
    }

    public static <T> List<ImmutablePair<T, T>> computeUnorderedPairs(Collection<T> collection) {
        ArrayList<T> elements = new ArrayList<T>(collection);
        ArrayList<ImmutablePair<T, T>> pairs = new ArrayList<ImmutablePair<T, T>>();
        int size = elements.size();
        for (int firstIndex = 0; firstIndex < size; ++firstIndex) {
            for (int secondIndex = firstIndex + 1; secondIndex < size; ++secondIndex) {
                pairs.add(new ImmutablePair(elements.get(firstIndex), elements.get(secondIndex)));
            }
        }
        return pairs;
    }

    public static <T> @Nullable T getLast(@NonNull List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.getLast();
    }

    public static <T> @Nullable List<T> getRest(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.subList(1, list.size());
    }

    public static <S extends Comparable<S>, T> void sortByFirst(PairList<S, T> list) {
        CollectionUtils.sortByFirst(list, Comparator.naturalOrder());
    }

    public static <S, T> void sortByFirst(PairList<S, T> list, Comparator<S> comparator) {
        CollectionUtils.sortBy(list, PairList::getFirst, comparator);
    }

    public static <S, T> void sortBySecond(PairList<S, T> list, Comparator<? super T> comparator) {
        CollectionUtils.sortBy(list, PairList::getSecond, comparator);
    }

    private static <S, T, C> void sortBy(final PairList<S, T> list, final BiFunction<PairList<S, T>, Integer, C> elementRetriever, final Comparator<? super C> comparator) {
        SortableDataUtils.sort(new ISortableData(){

            @Override
            public void swap(int i, int j) {
                list.swapEntries(i, j);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isLess(int i, int j) {
                int compare = comparator.compare(elementRetriever.apply(list, i), elementRetriever.apply(list, j));
                if (compare == 0) {
                    return i < j;
                }
                return compare < 0;
            }
        });
    }

    public static <T> List<T> asList(Collection<T> collection) {
        if (collection instanceof List) {
            List list = (List)collection;
            return list;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> asRandomAccessList(Collection<T> collection) {
        if (collection instanceof List) {
            List list = (List)collection;
            if (collection instanceof RandomAccess) {
                return list;
            }
        }
        return new ArrayList<T>(collection);
    }

    @SafeVarargs
    private static <T, C extends Collection<T>> C unionCollection(Supplier<C> collectionSupplier, @Nullable Collection<T> collection1, Collection<T> ... furtherCollections) {
        Collection result = (Collection)collectionSupplier.get();
        if (collection1 != null) {
            result.addAll(collection1);
        }
        for (Collection<T> collection : furtherCollections) {
            if (collection == null) continue;
            result.addAll(collection);
        }
        return (C)result;
    }

    @SafeVarargs
    public static <T> HashSet<T> unionSet(Collection<T> collection1, Collection<T> ... furtherCollections) {
        return CollectionUtils.unionCollection(HashSet::new, collection1, furtherCollections);
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> enumUnionSet(Set<T> initialSet, Set<T> ... otherSets) {
        EnumSet<T> union = EnumSet.copyOf(initialSet);
        for (Set<T> other : otherSets) {
            union.addAll(other);
        }
        return union;
    }

    @SafeVarargs
    public static <T> ArrayList<T> unionList(Collection<T> collection1, Collection<T> ... furtherCollections) {
        return CollectionUtils.unionCollection(ArrayList::new, collection1, furtherCollections);
    }

    public static <T> HashSet<T> unionSetAll(Collection<? extends Collection<T>> sets) {
        HashSet<T> result = new HashSet<T>();
        for (Collection<T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    public static <T> Set<T> subtract(@Nullable Collection<T> collection, @Nullable Collection<T> elementsToRemove) {
        HashSet<T> result = new HashSet<T>();
        if (collection != null) {
            result.addAll(collection);
        }
        if (elementsToRemove != null) {
            result.removeAll(elementsToRemove);
        }
        return result;
    }

    public static <T> void addAllSafe(Collection<T> collection1, @Nullable Collection<T> collection2) {
        if (collection2 != null) {
            collection1.addAll(collection2);
        }
    }

    @SafeVarargs
    public static <T> HashSet<T> intersectionSet(Collection<T> collection1, Collection<T> ... furtherCollections) {
        HashSet<T> result = new HashSet<T>(collection1);
        for (Collection<T> collection : furtherCollections) {
            if (collection instanceof Set) {
                result.retainAll(collection);
                continue;
            }
            result.retainAll(new HashSet<T>(collection));
        }
        return result;
    }

    @SafeVarargs
    public static <T> HashSet<T> differenceSet(Collection<T> collection1, Collection<? extends T> ... furtherCollections) {
        HashSet<T> result = new HashSet<T>(collection1);
        for (Collection<T> collection : furtherCollections) {
            if (collection instanceof Set) {
                result.removeAll(collection);
                continue;
            }
            result.removeAll(new HashSet<T>(collection));
        }
        return result;
    }

    @SafeVarargs
    public static <T, K> Collection<T> difference(Function<T, K> keyCalculator, Collection<T> initialCollection, Collection<? extends T> ... furtherCollections) {
        ListMap valuesByKey = (ListMap)initialCollection.stream().collect(ListMapCollector.groupingBy(keyCalculator));
        for (Collection<T> collection : furtherCollections) {
            for (T element : collection) {
                valuesByKey.removeCollection(keyCalculator.apply(element));
            }
        }
        return valuesByKey.getValues();
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable PairList<?, ?> pairs) {
        return pairs == null || pairs.isEmpty();
    }

    public static void truncateEnd(List<?> list, int numElements) {
        if (list.size() > numElements) {
            list.subList(numElements, list.size()).clear();
        }
    }

    public static <S> List<Set<S>> divideEvenlyIntoKSubsets(Set<S> set, int k, Random rnd) {
        int n = set.size();
        CCSMAssert.isTrue(n >= k, "The size of the set must be at least k");
        CCSMAssert.isTrue(k > 0, "k must be greater than 0");
        ArrayList<S> shuffled = new ArrayList<S>(set);
        Collections.shuffle(shuffled, rnd);
        ArrayList<Set<S>> result = new ArrayList<Set<S>>();
        int subsetSize = n / k + 1;
        for (int i = 0; i < n % k; ++i) {
            result.add(new HashSet(shuffled.subList(i * subsetSize, (i + 1) * subsetSize)));
        }
        int offset = n % k * subsetSize;
        subsetSize = n / k;
        for (int i = 0; i < k - n % k; ++i) {
            result.add(new HashSet(shuffled.subList(offset + i * subsetSize, offset + (i + 1) * subsetSize)));
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<List<T>> getAllPermutations(T ... elements) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        CollectionUtils.permute(Arrays.asList(elements), 0, result);
        return result;
    }

    private static <T> void permute(List<T> list, int index, List<List<T>> result) {
        for (int i = index; i < list.size(); ++i) {
            Collections.swap(list, i, index);
            CollectionUtils.permute(list, index + 1, result);
            Collections.swap(list, index, i);
        }
        if (index == list.size() - 1) {
            result.add(new ArrayList<T>(list));
        }
    }

    public static <T> List<List<T>> getPowerSet(List<T> input) {
        return CollectionUtils.getPowerSet(input, 0);
    }

    private static <T> List<List<T>> getPowerSet(List<T> input, int start) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (start >= input.size()) {
            result.add(new ArrayList());
        } else {
            T element = input.get(start);
            for (List<T> list : CollectionUtils.getPowerSet(input, start + 1)) {
                ArrayList<T> copy = new ArrayList<T>();
                copy.add(element);
                copy.addAll(list);
                result.add(list);
                result.add(copy);
            }
        }
        return result;
    }

    public static <T> List<T> emptyIfNull(@Nullable List<T> input) {
        if (input == null) {
            return CollectionUtils.emptyList();
        }
        return input;
    }

    public static <T> List<T> emptyIfNull(T @Nullable [] input) {
        if (input == null) {
            return CollectionUtils.emptyList();
        }
        return Arrays.asList(input);
    }

    public static <T> Set<T> emptyIfNull(@Nullable Set<T> input) {
        if (input == null) {
            return CollectionUtils.emptySet();
        }
        return input;
    }

    public static <K, V, M extends Map<K, V>> M emptyIfNull(@Nullable M input, Supplier<M> supplier) {
        return Optional.ofNullable(input).orElseGet(supplier);
    }

    public static <M> List<M> emptyListIfEmpty(Optional<M> input) {
        return input.map(xva$0 -> Arrays.asList(xva$0)).orElseGet(CollectionUtils::emptyList);
    }

    public static <T> T[] removeElementFromArray(T element, T[] array) {
        ArrayList<T> result = new ArrayList<T>(Arrays.asList(array));
        result.remove(element);
        return CollectionUtils.toArray(result, element.getClass());
    }

    public static <T> List<@NonNull T> filterNullEntries(Collection<@Nullable T> list) {
        return CollectionUtils.filter(list, Objects::nonNull);
    }

    public static <T> List<T> filterNullEntries(@Nullable T[] array) {
        return CollectionUtils.filterNullEntries(Arrays.asList(array));
    }

    public static <T> T[] concatenateArrays(T[] a, T[] b) {
        int length1 = a.length;
        int length2 = b.length;
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), length1 + length2);
        System.arraycopy(a, 0, newArray, 0, length1);
        System.arraycopy(b, 0, newArray, length1, length2);
        return newArray;
    }

    @SafeVarargs
    public static <T> List<T> concatenateLists(List<? extends T> first, List<? extends T> second, List<? extends T> ... moreLists) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(first);
        result.addAll(second);
        for (List<? extends T> additionalList : moreLists) {
            result.addAll(additionalList);
        }
        return result;
    }

    public static <T> boolean anyMatch(Collection<? extends T> collection, Predicate<T> predicate) {
        for (T element : collection) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <T, E extends Exception> boolean anyMatchWithException(Collection<? extends T> collection, PredicateWithException<T, E> predicate) throws E {
        for (T element : collection) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean allMatch(Collection<? extends T> collection, Predicate<T> predicate) {
        for (T element : collection) {
            if (predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean allMatchWithException(Collection<? extends T> collection, PredicateWithException<T, E> predicate) throws E {
        for (T element : collection) {
            if (predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    private static <T> Pair<List<T>, Set<T>> bottomSort(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        Pair<List<T>, Set<T>> topSortResult = CollectionUtils.topSort(collection, getSuccessors);
        return Pair.createPair(CollectionUtils.reverse((Collection)topSortResult.getFirst()), (Set)topSortResult.getSecond());
    }

    public static <T> List<T> bottomSortNoCyclesExpected(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        Pair topSortResult = CollectionUtils.bottomSort(collection, getSuccessors);
        CCSMAssert.isTrue(((Set)topSortResult.getSecond()).isEmpty(), () -> "Expected no cycles for bottom sort of " + String.valueOf(collection) + " but encountered cycle " + String.valueOf(topSortResult.getSecond()));
        return (List)topSortResult.getFirst();
    }

    public static <T> List<T> topSortNoCyclesExpected(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        Pair topSortResult = CollectionUtils.topSort(collection, getSuccessors);
        CCSMAssert.isTrue(((Set)topSortResult.getSecond()).isEmpty(), () -> "Expected no cycles for top sort of " + String.valueOf(collection) + " but encountered cycle " + String.valueOf(topSortResult.getSecond()));
        return (List)topSortResult.getFirst();
    }

    public static <T> Pair<List<T>, Set<T>> topSort(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        UnmodifiableSet<T> inputSet = CollectionUtils.asUnmodifiable(new HashSet<T>(collection));
        CounterSet numUnhandledPredecessors = new CounterSet();
        for (T element2 : collection) {
            Collection<T> successors = getSuccessors.apply(element2);
            if (successors == null) continue;
            successors.stream().filter(inputSet::contains).forEach(numUnhandledPredecessors::inc);
        }
        Deque freeElements = collection.stream().filter(element -> !numUnhandledPredecessors.contains(element)).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayList result = new ArrayList(collection.size());
        while (!freeElements.isEmpty()) {
            Object element3 = freeElements.remove();
            result.add(element3);
            CollectionUtils.handleTopSortElementSuccessors(getSuccessors.apply(element3), numUnhandledPredecessors, freeElements, inputSet);
        }
        return new Pair<List<T>, Set<T>>(result, numUnhandledPredecessors.getKeys());
    }

    private static <T> void handleTopSortElementSuccessors(@Nullable Collection<? extends T> successors, CounterSet<T> numUnhandledPredecessors, Deque<T> freeElements, UnmodifiableSet<T> filterSet) {
        if (successors != null) {
            successors.stream().filter(filterSet::contains).forEach(successor -> {
                numUnhandledPredecessors.inc(successor, -1);
                if (numUnhandledPredecessors.getValue(successor) <= 0) {
                    freeElements.add(successor);
                    numUnhandledPredecessors.remove(successor);
                }
            });
        }
    }

    public static <T extends Comparable<T>> Pair<List<T>, Set<T>> topSortRemoveCycles(Collection<T> collection, Function<T, @Nullable Collection<T>> getSuccessors, Function<T, Collection<T>> getPredecessors) {
        Set removedCycleElements = collection.stream().filter(node -> {
            Collection successors = (Collection)getSuccessors.apply(node);
            return successors != null && successors.contains(node);
        }).collect(Collectors.toSet());
        ArrayList<T> reducedCollection = new ArrayList<T>(collection);
        reducedCollection.removeIf(removedCycleElements::contains);
        Pair<List<T>, Set<T>> topSorted = CollectionUtils.topSort(reducedCollection, getSuccessors);
        if (((Set)topSorted.getSecond()).isEmpty()) {
            return new Pair<List<T>, Set<T>>((List)topSorted.getFirst(), removedCycleElements);
        }
        ArrayList tailElements = new ArrayList();
        List headElements = (List)topSorted.getFirst();
        ArrayList<T> cycle = CollectionUtils.sort((Collection)topSorted.getSecond());
        while (!cycle.isEmpty()) {
            Pair<List<T>, Set<T>> inverseTopSortedCycle = CollectionUtils.topSort(cycle, getPredecessors);
            tailElements.addAll((Collection)inverseTopSortedCycle.getFirst());
            cycle = CollectionUtils.sort((Collection)inverseTopSortedCycle.getSecond());
            if (!cycle.isEmpty()) {
                removedCycleElements.add((Comparable)cycle.removeLast());
            }
            Pair<List<T>, Set<T>> topSortedCycle = CollectionUtils.topSort(cycle, getSuccessors);
            headElements.addAll((Collection)topSortedCycle.getFirst());
            cycle = CollectionUtils.sort((Collection)topSortedCycle.getSecond());
        }
        headElements.addAll(CollectionUtils.reverse(tailElements));
        return new Pair<List<T>, Set<T>>(headElements, removedCycleElements);
    }

    public static <L extends List<T>, T extends Comparable<T>> Comparator<L> getListComparator() {
        return CollectionUtils.getListComparator(Comparable::compareTo);
    }

    public static <L extends List<T>, T> Comparator<L> getListComparator(Comparator<T> elementComparator) {
        return (o1, o2) -> {
            if (o1.size() != o2.size()) {
                return o1.size() - o2.size();
            }
            for (int i = 0; i < o1.size(); ++i) {
                int currentComparison = elementComparator.compare(o1.get(i), o2.get(i));
                if (currentComparison == 0) continue;
                return currentComparison;
            }
            return 0;
        };
    }

    public static <P extends Pair<T, S>, T extends Comparable<T>, S extends Comparable<S>> Comparator<P> getPairComparator() {
        return Comparator.comparing(ImmutablePair::getFirst).thenComparing(ImmutablePair::getSecond);
    }

    public static <T> Consumer<T> emptyConsumer() {
        return x -> {};
    }

    public static List<String> parseMultiValueStringToList(String valueList, boolean filterOutLineComments) {
        List<String> lines = StringUtils.splitWithEscapeCharacter(valueList, Character.valueOf('\n'));
        return CollectionUtils.parseMultiValueStringToList(lines, filterOutLineComments);
    }

    public static List<String> parseMultiValueStringToList(List<String> valueListLines, boolean filterOutLineComments) {
        ArrayList<String> results = new ArrayList<String>();
        for (String line : valueListLines) {
            if (filterOutLineComments && line.startsWith(CONNECTOR_CONFIG_MULTI_VALUE_INPUT_LINE_COMMENT_PREFIX)) continue;
            line = line.replace("\\" + MULTI_VALUE_DELIMITER, "__ESCAPED_MULTI_VALUE_DELIMITER__");
            line = StringUtils.strip(line, MULTI_VALUE_DELIMITER.toString());
            line = line.replaceAll(",+", ",");
            line = line.replace("__ESCAPED_MULTI_VALUE_DELIMITER__", "\\" + MULTI_VALUE_DELIMITER);
            List<String> result = StringUtils.splitWithEscapeCharacter(line, MULTI_VALUE_DELIMITER);
            for (String value : result) {
                if (!StringUtils.isEmpty(value)) continue;
                throw new IllegalArgumentException("Found duplicate comma (empty value) in list: " + String.valueOf(valueListLines));
            }
            results.addAll(result);
        }
        return results;
    }

    public static <T1, T2, RESULT> List<RESULT> combine(Collection<T1> firstValues, Collection<T2> secondValues, BiFunction<T1, T2, RESULT> combineFunction) {
        ArrayList resultList = new ArrayList(firstValues.size());
        return CollectionUtils.combine(firstValues, secondValues, resultList, combineFunction);
    }

    public static <T1, T2, RESULT, COLLECTION extends Collection<RESULT>> COLLECTION combine(Collection<T1> firstValues, Collection<T2> secondValues, COLLECTION resultCollection, BiFunction<T1, T2, RESULT> combineFunction) {
        CCSMAssert.isTrue(firstValues.size() == secondValues.size(), "Can only combine collections of the same size.");
        Iterator<T1> firstIterator = firstValues.iterator();
        Iterator<T2> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext()) {
            resultCollection.add(combineFunction.apply(firstIterator.next(), secondIterator.next()));
        }
        return resultCollection;
    }

    public static <T1, T2> void forEach(Iterable<T1> firstValues, Iterable<T2> secondValues, BiConsumer<T1, T2> combineFunction) {
        Iterator<T1> firstIterator = firstValues.iterator();
        Iterator<T2> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext() && secondIterator.hasNext()) {
            combineFunction.accept(firstIterator.next(), secondIterator.next());
        }
        if (firstIterator.hasNext() || secondIterator.hasNext()) {
            throw new AssertionError((Object)"First and second iterable must have the same size!");
        }
    }

    public static <T1, E extends Exception> void forEach(Iterable<T1> values, ConsumerWithException<T1, E> consumer) throws E {
        for (T1 value : values) {
            consumer.accept(value);
        }
    }

    public static <T1, T2, E extends Exception> void forEachWithException(Collection<T1> firstValues, Collection<T2> secondValues, BiConsumerWithException<? super T1, ? super T2, E> combineFunction) throws E {
        CCSMAssert.isTrue(firstValues.size() == secondValues.size(), "Can only combine collections of the same size.");
        Iterator<T1> firstIterator = firstValues.iterator();
        Iterator<T2> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext() && secondIterator.hasNext()) {
            combineFunction.accept(firstIterator.next(), secondIterator.next());
        }
    }

    public static <T1, T2> Iterable<Pair<T1, T2>> zip(Iterable<T1> firstIterable, Iterable<T2> secondIterable) {
        CCSMAssert.isNotNull(firstIterable, () -> String.format("Expected \"%s\" to be not null", "firstIterable"));
        CCSMAssert.isNotNull(secondIterable, () -> String.format("Expected \"%s\" to be not null", "secondIterable"));
        return () -> CollectionUtils.zipIterators(firstIterable.iterator(), secondIterable.iterator());
    }

    public static <T1, T2> Stream<Pair<T1, T2>> zipAsStream(Iterable<T1> firstIterable, Iterable<T2> secondIterable) {
        return StreamSupport.stream(CollectionUtils.zip(firstIterable, secondIterable).spliterator(), false);
    }

    @SafeVarargs
    public static <T> Iterator<T> sortedIterator(SortedSet<T> first, SortedSet<T> second, SortedSet<T> ... further) {
        Comparator<T> comparator = first.comparator();
        if (comparator == null) {
            Comparator tmp = Comparator.naturalOrder();
            comparator = tmp;
        }
        ArrayList<Collection> collections = new ArrayList<Collection>(2 + further.length);
        collections.add(first);
        collections.add(second);
        collections.addAll(Arrays.asList((Collection[])further));
        return CollectionUtils.sortedIterator(comparator, collections);
    }

    public static <T> @NonNull Iterator<T> sortedIterator(Comparator<? super T> comparator, Collection<? extends Iterable<T>> collections) {
        return new SortingIterator<T>(comparator, collections);
    }

    @SafeVarargs
    public static <T> boolean endsWith(List<T> list, T ... elements) {
        return CollectionUtils.endsWith(list, Function.identity(), elements);
    }

    @SafeVarargs
    public static <T, U> boolean endsWith(List<T> list, Function<T, U> listElementMapper, U ... elements) {
        if (list.size() < elements.length) {
            return false;
        }
        ListIterator<T> listIterator = list.listIterator(list.size() - elements.length);
        for (U element : elements) {
            if (Objects.equals(listElementMapper.apply(listIterator.next()), element)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAny(Set<T> container, Collection<T> candidates) {
        return CollectionUtils.containsAnyBut(container, candidates, Collections.emptySet());
    }

    public static <T> boolean containsAnyBut(Set<T> container, Collection<T> candidates, Set<T> exclusionSet) {
        for (T t : candidates) {
            if (exclusionSet.contains(t) || !container.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <K, I, V, C extends Collection<V>> Map<K, C> calculateTransitiveMap(Map<K, ? extends Collection<I>> firstMap, Map<I, ? extends Collection<V>> secondMap, Supplier<Map<K, C>> mapSupplier, Supplier<C> collectionSupplier) {
        Map<K, C> result = mapSupplier.get();
        for (Map.Entry<K, Collection<I>> entry : firstMap.entrySet()) {
            for (I intermediateValue : entry.getValue()) {
                Collection<V> secondMapValues;
                Collection existing = (Collection)result.get(entry.getKey());
                if (existing == null) {
                    existing = (Collection)collectionSupplier.get();
                }
                if ((secondMapValues = secondMap.get(intermediateValue)) != null) {
                    existing.addAll(secondMapValues);
                }
                result.put(entry.getKey(), existing);
            }
        }
        return result;
    }

    public static <T> int indexOfFirstMatch(List<T> list, Predicate<T> predicate) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (!predicate.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <K, V> Map<K, V> zipAsMap(SequencedCollection<K> first, SequencedCollection<V> second) {
        CCSMAssert.isTrue(first.size() == second.size(), () -> "Need the same number of elements in the given lists. Found " + first.size() + " / " + second.size());
        return CollectionUtils.zipToMap(first.iterator(), second.iterator());
    }

    public static <K, V> Map<K, V> zipToMap(Iterator<K> first, Iterator<V> second) {
        HashMap resultMap = new HashMap();
        CollectionUtils.forEach(CollectionUtils.asIterable(first), CollectionUtils.asIterable(second), resultMap::put);
        return resultMap;
    }

    public static <T> List<T> subListFrom(List<T> list, int fromIndex) {
        return list.subList(fromIndex, list.size());
    }

    public static <T> ArrayList<T> repeat(Function<Integer, T> factory, int count) {
        CCSMAssert.isFalse(count < 0, () -> "Repeating objects for negative number " + count + " of objects is not possible.");
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(factory.apply(i));
        }
        return result;
    }

    public static <T> Predicate<Map.Entry<T, ?>> onKey(Predicate<? super T> predicate) {
        return entry -> predicate.test((Object)entry.getKey());
    }

    public static <T> Predicate<Map.Entry<?, T>> onValue(Predicate<? super T> predicate) {
        return entry -> predicate.test((Object)entry.getValue());
    }

    @Contract(value="null -> null; !null -> !null")
    public static <K, V> @Nullable Map<V, K> inverseMap(@Nullable Map<K, V> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        return sourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <K, V, C extends Collection<K>> Map<V, C> inverseMap(Map<K, ? extends Collection<V>> originalMap, Supplier<Map<V, C>> mapSupplier, Supplier<C> collectionSupplier) {
        Map<Collection, C> result = mapSupplier.get();
        for (Map.Entry<K, Collection<V>> entry : originalMap.entrySet()) {
            K key = entry.getKey();
            for (V value : entry.getValue()) {
                Collection existing = (Collection)result.get(value);
                if (existing == null) {
                    existing = (Collection)collectionSupplier.get();
                }
                existing.add(key);
                result.put((Collection)value, (C)existing);
            }
        }
        return result;
    }

    public static <T> @Nullable List<T> limit(@Nullable List<T> list, int n) {
        if (list == null || list.size() <= n) {
            return list;
        }
        return list.subList(0, n);
    }

    public static <T> @NonNull List<T> limitList(@Nullable Integer limitParameter, List<T> toLimit) {
        int limit = Optional.ofNullable(limitParameter).orElse(-1);
        if (limit < 0) {
            limit = toLimit.size();
        }
        return Objects.requireNonNull(CollectionUtils.limit(toLimit, limit));
    }

    public static <T> Iterable<T> asIterable(@NonNull Iterator<T> iterator) {
        CCSMAssert.isNotNull(iterator, () -> String.format("Expected \"%s\" to be not null", "iterator"));
        return () -> iterator;
    }

    public static <T> Iterable<T> asIterable(@NonNull Supplier<@NonNull Iterator<T>> iteratorSupplier) {
        CCSMAssert.isNotNull(iteratorSupplier, () -> String.format("Expected \"%s\" to be not null", "iteratorSupplier"));
        return iteratorSupplier::get;
    }

    public static <T1, T2> Iterator<Pair<T1, T2>> zipIterators(final @NonNull Iterator<T1> iterator1, final @NonNull Iterator<T2> iterator2) {
        CCSMAssert.isNotNull(iterator1, () -> String.format("Expected \"%s\" to be not null", "iterator1"));
        CCSMAssert.isNotNull(iterator2, () -> String.format("Expected \"%s\" to be not null", "iterator2"));
        return new Iterator<Pair<T1, T2>>(){

            @Override
            public boolean hasNext() {
                boolean i2Next;
                boolean i1Next = iterator1.hasNext();
                CCSMAssert.isTrue(i1Next == (i2Next = iterator2.hasNext()), "Received iterators with different element count");
                return i1Next;
            }

            @Override
            public Pair<T1, T2> next() {
                return new Pair(iterator1.next(), iterator2.next());
            }

            @Override
            public void remove() {
                iterator1.remove();
                iterator2.remove();
            }
        };
    }

    public static <K, V> Map<K, V> filterMapByValue(@NonNull Map<K, V> sourceMap, Predicate<V> predicate) {
        HashMap<K, V> filteredMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            filteredMap.put(entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    public static <T> int binarySearch(T key, int size, IntFunction<T> accessor, Comparator<T> comparator) {
        int lower = 0;
        int upper = size;
        if (upper == 0) {
            return -1;
        }
        while (lower < upper) {
            int middle = lower + upper >>> 1;
            int compare = comparator.compare(accessor.apply(middle), key);
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                lower = middle + 1;
                continue;
            }
            upper = middle;
        }
        return -lower - 1;
    }

    public static <T> BinaryOperator<T> throwingMerger(Function<? super T, ?> keyMapper) {
        CCSMAssert.isNotNull(keyMapper, () -> String.format("Expected \"%s\" to be not null", "keyMapper"));
        return (t1, t2) -> {
            throw new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", keyMapper.apply(t1), t1, t2));
        };
    }

    public static <T> Collector<T, ?, ArrayList<T>> toArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T> Collector<T, ?, UnmodifiableList<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(CollectionUtils.toArrayList(), CollectionUtils::asUnmodifiable);
    }

    public static <E extends Enum<E>> Collector<E, ?, EnumSet<E>> toEnumSet(Class<E> elementType) {
        if (!elementType.isEnum()) {
            throw new ClassCastException(String.format("%s is not an enum", elementType));
        }
        return Collector.of(() -> EnumSet.noneOf(elementType), Set::add, (x$0, xva$1) -> CollectionUtils.enumUnionSet(x$0, xva$1), Collector.Characteristics.UNORDERED);
    }

    public static <A, R> R emptyResult(Collector<?, A, R> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }

    public static <T> void setValuesAtIndices(List<T> targetList, List<Integer> indicesToSet, List<T> valuesToSet) {
        for (int i = 0; i < indicesToSet.size(); ++i) {
            targetList.set(indicesToSet.get(i), valuesToSet.get(i));
        }
    }

    @Contract(pure=true)
    public static int computeHashMapCapacity(int expectedSize, float loadFactor) {
        return (int)Math.ceil((float)expectedSize / loadFactor);
    }

    public static Stream<Object> streamArray(Object array) {
        CCSMAssert.isTrue(array.getClass().isArray(), () -> String.format("Expected \"%s\" to be an array, but was: %s", array, array.getClass()));
        return IntStream.range(0, Array.getLength(array)).mapToObj(index -> Array.get(array, index));
    }

    public static <T, E extends Exception> void processInBatches(@NonNull Set<T> set, int batchSize, @NonNull ConsumerWithException<List<T>, E> processor) throws E {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be greater than zero.");
        }
        Iterator<T> iterator = set.iterator();
        ArrayList<T> batch = new ArrayList<T>(batchSize);
        while (iterator.hasNext()) {
            batch.add(iterator.next());
            if (batch.size() != batchSize) continue;
            processor.accept(batch);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            processor.accept(batch);
        }
    }

    public static <K, T, S> Map<K, S> transformMapValues(Map<K, T> map, Function<? super T, ? extends S> valueTransformationFunction) {
        HashMap<K, S> result = new HashMap<K, S>();
        for (Map.Entry<K, T> entry : map.entrySet()) {
            result.put(entry.getKey(), valueTransformationFunction.apply(entry.getValue()));
        }
        return result;
    }

    private CollectionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static class SortingIterator<T>
    implements Iterator<T> {
        private final Comparator<? super T> comparator;
        private final Map<Iterator<T>, Optional<T>> iteratorsWithNextValue = new IdentityHashMap<Iterator<T>, Optional<T>>();
        private final List<Iterator<T>> lastResultIterators = new ArrayList<Iterator<T>>();

        private SortingIterator(Comparator<? super T> comparator, Collection<? extends Iterable<T>> collections) {
            this.comparator = Comparator.nullsLast(comparator);
            for (Iterable<T> collection : collections) {
                this.iteratorsWithNextValue.put(collection.iterator(), Optional.empty());
            }
        }

        @Override
        public boolean hasNext() {
            return this.iteratorsWithNextValue.entrySet().stream().anyMatch(entry -> ((Optional)entry.getValue()).isPresent() || ((Iterator)entry.getKey()).hasNext());
        }

        @Override
        public T next() {
            this.lastResultIterators.clear();
            Object result = null;
            Iterator<Map.Entry<Iterator<T>, Optional<T>>> iterator = this.iteratorsWithNextValue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Iterator<T>, Optional<T>> entry = iterator.next();
                T nextCandidate = this.getCandidateFromIterator(entry);
                if (nextCandidate == null) {
                    iterator.remove();
                    continue;
                }
                int compare = this.comparator.compare(result, nextCandidate);
                if (compare > 0) {
                    this.lastResultIterators.clear();
                    this.lastResultIterators.add(entry.getKey());
                    result = nextCandidate;
                    continue;
                }
                if (compare != 0) continue;
                this.lastResultIterators.add(entry.getKey());
            }
            if (this.lastResultIterators.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.lastResultIterators.forEach(iter -> this.iteratorsWithNextValue.put((Iterator<T>)iter, Optional.empty()));
            return result;
        }

        private T getCandidateFromIterator(Map.Entry<Iterator<T>, Optional<T>> entry) {
            Optional<T> nextFromIter = entry.getValue();
            Iterator<T> iterator = entry.getKey();
            if (nextFromIter.isEmpty()) {
                if (iterator.hasNext()) {
                    nextFromIter = Optional.of(iterator.next());
                    entry.setValue(nextFromIter);
                } else {
                    return null;
                }
            }
            return nextFromIter.get();
        }

        @Override
        public void remove() {
            if (this.lastResultIterators.isEmpty()) {
                throw new IllegalStateException();
            }
            this.lastResultIterators.forEach(Iterator::remove);
        }
    }
}

