/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.objects.LongStringUtils;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;

public class SerializedStringObject
extends SerializedObjectBase {
    private String value;

    public SerializedStringObject(String value, SerializedEntityPool pool) {
        super(pool, 0);
        this.value = value;
    }

    public SerializedStringObject(DataInputStream din, SerializedEntityPool pool, boolean longString) throws IOException {
        super(pool, 0);
        this.value = longString ? LongStringUtils.readLongString(din) : din.readUTF();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void serialize(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        this.serializeContent(dos, serializer);
    }

    @Override
    protected void serializeContent(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        serializer.serializeStringObject(this.value);
    }

    @Override
    protected byte getObjectTagConstant() {
        throw new AssertionError((Object)"Should not be called!");
    }

    @Override
    protected void serializeObjectContent(DataOutputStream dos, SerializedEntitySerializer serializer) {
        throw new AssertionError((Object)"Should not be called!");
    }
}

