/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.architecture.ArchitectureConverter;
import com.teamscale.service.architecture.ArchitectureUploadService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Hidden
@LegacyApi
@Path(value="p/{project}/architecture-upload")
public class LegacyArchitectureUploadService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @POST
    @Operation(summary="Upload architecture", description="Uploads architecture in JSON format.", tags={"Architecture"}, responses={@ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    public Response uploadArchitecture(@BeanParam ExternalUploadServiceQueryOptions parameters, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String commitMessage, @RequestBody(required=true) ArchitectureUploadService.ArchitectureInfoWithUniformPath architectureInfo) throws ConQATException {
        return LegacyApiUtils.apiCallWithSuccess(ArchitectureUploadService.class, (ResourceContext)this.resourceContext, resource -> resource.uploadArchitectureAsJson(parameters, commitMessage, architectureInfo, false), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyApiUtils.wrapNotFoundInBadRequest()});
    }

    @POST
    @Operation(summary="Upload architecture", description="Uploads (an) architecture(s) as multipart data.", tags={"Architecture"}, responses={@ApiResponse(responseCode="400", description="No path for architecture given."), @ApiResponse(responseCode="400", description="Architecture path must have extension .architecture."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Consumes(value={"multipart/form-data"})
    public Response uploadArchitecture(@BeanParam ExternalUploadServiceQueryOptions parameters, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String commitMessage, @Parameter(description="The parameter that determines the upload format.") @QueryParam(value="format") ArchitectureConverter.EArchitectureFormat format, @Parameter(description="The parameter used for passing in a template architecture.") @QueryParam(value="template") String templatePath, FormDataMultiPart multiPart) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(ArchitectureUploadService.class, (ResourceContext)this.resourceContext, resource -> resource.uploadArchitecture(parameters, commitMessage, format, templatePath, multiPart, false), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyApiUtils.wrapNotFoundInBadRequest()});
    }

    @DELETE
    @Path(value="{uniformPath}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Operation(summary="Delete architecture", description="Deletes the architecture identified by the provided architecture path.", tags={"Architecture"}, responses={@ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="Can't perform architecture delete for project with no architecture commit.")})
    public Response deleteArchitecture(@BeanParam ExternalUploadServiceQueryOptions parameters, @Parameter(description="The uniform path of the deleted architecture") @PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String commitMessage) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(ArchitectureUploadService.class, (ResourceContext)this.resourceContext, resource -> resource.deleteArchitecture(parameters, uniformPath, commitMessage), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyApiUtils.wrapNotFoundInBadRequest()});
    }
}

