/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.audit.FileGroup;
import com.teamscale.service.audit.FilesWithIdenticalPropertyServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/audit/files-with-identical-name/{uniformPath: .*}")
public class FilesWithIdenticalFileNameService
extends FilesWithIdenticalPropertyServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get files with an identical names", description="Retrieves files.", tags={"Audit"}, responses={@ApiResponse(responseCode="204", description="No data available")})
    public List<FileGroup> getFilesWithIdenticalNames(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="regex") String regexFilter) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        return this.findFilesWithIdenticalProperties(regexFilter, historyAccessOption, uniformPath);
    }

    @Override
    protected Map<String, Set<UniformPath>> groupPaths(List<UniformPath> uniformPaths) {
        HashMap<String, Set<UniformPath>> result = new HashMap<String, Set<UniformPath>>();
        for (UniformPath path : uniformPaths) {
            String fileName = path.getLastSegment();
            result.computeIfAbsent(fileName, x -> new HashSet()).add(path);
        }
        return result;
    }
}

