/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.xclones;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Path(value="api/audit/external-x-clones/file")
public class ExternalXCloneFileService
extends ApiBase {
    @GET
    @Operation(summary="Get external file content", description="Retrieves the file content of a file from disk with local pre-processing.", tags={"Audit"}, responses={@ApiResponse(responseCode="404", description="The file with the given path could not be found.")})
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="{path}")
    public FormattedTokenElementInfo getExternalFileWithPreprocessing(@Parameter(description="The path to retrieve files for") @PathParam(value="path") String path) {
        try {
            String content = FileSystemUtils.readFileUTF8((File)new File(path));
            return new FormattedTokenElementInfo(TokenElementInfo.createWithLocalPreprocessing((String)path, (ELanguage)ELanguage.fromPath((String)path), (String)content), EnumSet.noneOf(EExtendedResourceType.class));
        }
        catch (IOException e) {
            throw new NotFoundException("File not found: " + path + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

