/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.badge;

import com.teamscale.service.badge.CriticalChangeBadgeQueryParams;
import com.teamscale.service.badge.MetricGroupBadgeQueryParams;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commits.CommitAlertsBadgeCreator;
import com.teamscale.service.findings.badge.FindingBadgeCreator;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.merge_request.critical_change.MergeRequestCriticalChangeBadgeCreator;
import com.teamscale.service.metrics.badge.MergeRequestMetricBadgeCreator;
import com.teamscale.service.metrics.badge.MergeRequestMetricGroupBadgeCreator;
import com.teamscale.service.requirements_tracing.SpecItemsBadgeCreator;
import com.teamscale.service.testgap.badge.TgaBadgeCreator;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

@Path(value="api/badges/")
public class StaticBadgeService
extends ApiBase {
    private static final String FINDINGS_BADGE_DESCRIPTION = "Returns a static findings churn badge as SVG";

    @GET
    @Path(value="findings/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static findings churn badge as SVG", description="Returns a static findings churn badge as SVG", tags={"Findings", "Badge"})
    public String getStaticBadge(@QueryParam(value="added") int addedFindings, @QueryParam(value="changed") int inChangedCodeFindings, @QueryParam(value="removed") int removedFindings) {
        try {
            return new FindingBadgeCreator(addedFindings, inChangedCodeFindings, removedFindings, false).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating findings badge.", (Throwable)e);
        }
    }

    @GET
    @Path(value="findings/static/png")
    @Produces(value={"image/svg+xml"})
    @Deprecated
    @RequiresNoLogin
    @Operation(summary="Returns a static findings churn badge as SVG", description="Returns a static findings churn badge as SVG. Provided for backward compatibility.", tags={"Findings", "Badge"})
    public String getStaticBadgeAsPng(@QueryParam(value="added") int addedFindings, @QueryParam(value="changed") int inChangedCodeFindings, @QueryParam(value="removed") int removedFindings) {
        return this.getStaticBadge(addedFindings, inChangedCodeFindings, removedFindings);
    }

    @GET
    @Path(value="spec-items/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static SVG badge for changed specification items", tags={"Specification Items", "Badge"})
    public String getStaticRequirementsBadge(@QueryParam(value="affectedItems") int affectedRequirements) {
        try {
            return new SpecItemsBadgeCreator(affectedRequirements).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating requirements badge.", (Throwable)e);
        }
    }

    @GET
    @Path(value="test-gap/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static SVG badge for test gaps", tags={"Test Gap Analysis", "Badge"})
    public byte[] getStaticTestGapBadge(@QueryParam(value="ratio") double ratio, @QueryParam(value="testedChurn") int testedChurn, @QueryParam(value="untestedChange") int untestedChange, @QueryParam(value="untestedAddition") int untestedAddition, @QueryParam(value="format") String format, @QueryParam(value="incompleteBuildText") @DefaultValue(value="") String incompleteBuildText) {
        try {
            return new TgaBadgeCreator(ratio, testedChurn, untestedChange, untestedAddition, format, "", incompleteBuildText).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating test gap badge.", (Throwable)e);
        }
    }

    @GET
    @Path(value="commit-alerts/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static SVG badge for commit alerts", tags={"Badge"})
    public String getStaticCommitAlertsBadge(@QueryParam(value="commitAlerts") int commitAlerts) {
        try {
            return new CommitAlertsBadgeCreator(commitAlerts).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating test gap badge.", (Throwable)e);
        }
    }

    @GET
    @Path(value="metric/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static SVG badge for metrics", tags={"Metrics", "External Metrics", "Badge"})
    public byte[] getStaticMetricBadge(@QueryParam(value="metric") String metricName, @QueryParam(value="value") String metricResult, @QueryParam(value="color") ETrafficLightColor assessmentColor, @QueryParam(value="incompleteBuildText") @DefaultValue(value="") String incompleteBuildText) {
        try {
            return new MergeRequestMetricBadgeCreator(metricName, metricResult, assessmentColor, incompleteBuildText).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating metric badge.", (Throwable)e);
        }
    }

    @GET
    @Path(value="metric-group/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static SVG badge for a metric group", tags={"Metrics", "External Metrics", "Badge"})
    public byte[] getStaticMetricGroupBadge(@BeanParam MetricGroupBadgeQueryParams queryParams) {
        try {
            return new MergeRequestMetricGroupBadgeCreator(queryParams).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating metric badge.", (Throwable)e);
        }
    }

    @GET
    @Path(value="critical-change/static")
    @Produces(value={"image/svg+xml"})
    @RequiresNoLogin
    @Operation(summary="Returns a static SVG critical changes badge", tags={"Badge"})
    public byte[] getStaticCriticalChangeBadge(@BeanParam CriticalChangeBadgeQueryParams queryParams) {
        try {
            return new MergeRequestCriticalChangeBadgeCreator(queryParams).createBadge();
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Error creating metric badge.", (Throwable)e);
        }
    }
}

