/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.merge_request.MergeBaseCacheIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.BadRequestException;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

public abstract class DirectedCommitDeltaServiceBase
extends ApiBase {
    protected MergeBaseInfo getMergeBaseInfo(CommitDescriptor sourceCommit, CommitDescriptor targetCommit, String cacheKey) throws StorageException, BadRequestException {
        Optional mergeBaseInfo;
        if (cacheKey != null && (mergeBaseInfo = this.openProjectIndex(MergeBaseCacheIndex.class, null).getValue(cacheKey)).isPresent()) {
            return (MergeBaseInfo)mergeBaseInfo.get();
        }
        return this.computeNewMergeBaseInfo(sourceCommit, targetCommit);
    }

    private MergeBaseInfo computeNewMergeBaseInfo(CommitDescriptor sourceCommit, CommitDescriptor targetCommit) throws StorageException {
        CommitDescriptorIndex commitIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        try {
            return (MergeBaseInfo)MergeBaseResolver.computeMergeBaseInfo((CommitDescriptor)sourceCommit, (CommitDescriptor)targetCommit, (CommitDescriptorIndex)commitIndex).orElseThrow(() -> new BadRequestException("Could not find a common ancestor commit for " + String.valueOf(sourceCommit) + " and " + String.valueOf(targetCommit) + ". Maybe the analyzed history is too short?"));
        }
        catch (CommitResolutionException e) {
            if (e.commit.isHeadCommit()) {
                throw new BadRequestException("Could not find any commits on branch " + e.commit.getBranchName() + "!", (Throwable)e);
            }
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

