/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndexUtils;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMetrics;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/external-analysis/session/{sessionId}/external-metrics")
public class ExternalMetricsUploadService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload external metrics", description="Adds external metrics to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis", "External Metrics"}, responses={@ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="404", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Session has been committed or deleted."), @ApiResponse(responseCode="400", description="Attempted to upload value for metric which is not configured in the metric schema."), @ApiResponse(responseCode="400", description="Attempted to upload null value for metric which is not allowed."), @ApiResponse(responseCode="400", description="Upload of counter set metrics not supported."), @ApiResponse(responseCode="400", description="Unknown/unsupported value type."), @ApiResponse(responseCode="400", description="Upload of non-numeric value for this type of metric is not supported."), @ApiResponse(responseCode="400", description="Upload of non-list/non-array value for this type of metric is not supported."), @ApiResponse(responseCode="400", description="Expected array/list of size 3 for an assessment metric."), @ApiResponse(responseCode="400", description="Upload of null value as component type of an assessment metric is not supported."), @ApiResponse(responseCode="400", description="Upload of non-numeric value as component type for assessment metric is not supported.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void uploadExternalMetrics(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) List<ExternalMetricsEntry> externalMetrics) throws StorageException {
        ArrayList<IExternalUploadRequestPart> requestParts = new ArrayList<IExternalUploadRequestPart>(externalMetrics);
        this.process(EHttpMethod.POST, requestParts, parameters, sessionId);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, List<IExternalUploadRequestPart> findingData, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        MetricSchemaIndex metricSchemaIndex = this.openProjectIndex(MetricSchemaIndex.class, "metric-schema", HistoryAccessOption.readHeadUnbranched());
        Map schemaEntryByName = MetricSchemaIndexUtils.readSchema((MetricSchemaIndex)metricSchemaIndex);
        ArrayList<ExternalAnalysisImportInfoMetrics> infos = new ArrayList<ExternalAnalysisImportInfoMetrics>();
        for (IExternalUploadRequestPart requestPart : findingData) {
            PairList metrics = new PairList();
            ExternalMetricsEntry externalFindingFileData = (ExternalMetricsEntry)requestPart;
            for (Map.Entry<String, Object> entry : externalFindingFileData.metrics.entrySet()) {
                String metricName = entry.getKey();
                metrics.add((Object)metricName, (Object)ExternalMetricsUploadService.ensureCorrectFormat(entry.getValue(), (MetricDirectorySchemaEntry)schemaEntryByName.get(metricName), metricName));
            }
            infos.add(new ExternalAnalysisImportInfoMetrics(externalFindingFileData.path, metrics));
        }
        sessionIndex.insertAndMergeImportInfos(session, Collections.singletonList(new ExternalAnalysisImportInfos(infos)));
    }

    private static Serializable ensureCorrectFormat(Object value, MetricDirectorySchemaEntry schemaEntry, String metricName) throws BadRequestException {
        if (schemaEntry == null) {
            throw new BadRequestException("Attempted to upload value for metric " + metricName + " which is not configured in the metric schema. Please check your analysis profile!");
        }
        if (value == null) {
            throw new BadRequestException("Attempted to upload null value for metric " + metricName + " which is not allowed!");
        }
        return switch (schemaEntry.getValueType()) {
            default -> throw new MatchException(null, null);
            case EMetricValueType.NUMERIC -> {
                ExternalMetricsUploadService.checkIsNumber(value, "numeric", metricName);
                yield ((Number)value).doubleValue();
            }
            case EMetricValueType.TIMESTAMP, EMetricValueType.DATE_ONLY -> {
                ExternalMetricsUploadService.checkIsNumber(value, "timestamp", metricName);
                yield ((Number)value).longValue();
            }
            case EMetricValueType.ASSESSMENT -> ExternalMetricsUploadService.convertToAssessment(value, metricName);
            case EMetricValueType.STRING -> (String)value;
            case EMetricValueType.COUNTER_SET -> throw new BadRequestException("Upload of counter set metrics not supported! Metric name: " + metricName);
        };
    }

    private static void checkIsNumber(Object value, String typeNameForErrorMessage, String metricName) throws BadRequestException {
        if (!(value instanceof Number)) {
            throw new BadRequestException("Upload of non-numeric value of type " + value.getClass().getSimpleName() + " for " + typeNameForErrorMessage + " metric " + metricName + " not supported!");
        }
    }

    private static Serializable convertToAssessment(Object value, String metricName) throws BadRequestException {
        Assessment assessment = new Assessment();
        if (!(value instanceof List)) {
            throw new BadRequestException("Upload of non-list/non-array value of type " + value.getClass().getSimpleName() + " for assessment metric " + metricName + " not supported!");
        }
        List valueList = (List)value;
        if (valueList.size() != 3) {
            throw new BadRequestException("Expected array/list of size 3 for assessment metric " + metricName + "!");
        }
        assessment.add(ETrafficLightColor.GREEN, ExternalMetricsUploadService.getAssessmentIntValue(valueList.get(0), metricName));
        assessment.add(ETrafficLightColor.YELLOW, ExternalMetricsUploadService.getAssessmentIntValue(valueList.get(1), metricName));
        assessment.add(ETrafficLightColor.RED, ExternalMetricsUploadService.getAssessmentIntValue(valueList.get(2), metricName));
        return assessment;
    }

    private static int getAssessmentIntValue(Object value, String metricName) throws BadRequestException {
        if (value == null) {
            throw new BadRequestException("Upload of null value as component type of an assessment metric for metric " + metricName + " not supported!");
        }
        if (!(value instanceof Number)) {
            throw new BadRequestException("Upload of non-numeric value of type " + value.getClass().getSimpleName() + " as component type for assessment metric " + metricName + " not supported!");
        }
        return ((Number)value).intValue();
    }

    public static class ExternalMetricsEntry
    implements IExternalUploadRequestPart {
        private static final String PATH_PROPERTY = "path";
        private static final String METRICS_PROPERTY = "metrics";
        @JsonProperty(value="path")
        private final String path;
        @JsonProperty(value="metrics")
        private final Map<String, Object> metrics;

        @JsonCreator
        public ExternalMetricsEntry(@JsonProperty(value="path") String path, @JsonProperty(value="metrics") Map<String, Object> metrics) {
            this.path = path;
            this.metrics = metrics;
        }
    }
}

