/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/configuration-tools")
public class ConfigurationToolsService
extends ApiBase {
    @GET
    @Operation(summary="Get analysis tools", description="Retrieves the available tools based on the languages provided. Teamscale itself is not returned as a tool.", tags={"System"})
    @RequiresNoPermission(description="No specific permissions required to retrieve the available tools")
    public Set<EAnalysisTool> getAnalysisTools(@Parameter(description="Languages to retrieve possible tools for", required=true) @QueryParam(value="language") Set<ELanguage> languages) {
        Set tools = EAnalysisTool.getAllToolsFor(languages);
        tools.remove(EAnalysisTool.TEAMSCALE);
        return tools;
    }

    @GET
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get analysis tools", description="Returns the available analysis tools for a specific project. Teamscale itself is not returned as a tool.", tags={"Project", "Analysis profiles"})
    public Set<EAnalysisTool> getAnalysisToolsForProject(@PathParam(value="project") PublicProjectId projectId, @Parameter(description="Languages to retrieve the project's tools for", required=true) @QueryParam(value="language") Set<ELanguage> languages) throws StorageException {
        List analysisProfiles = AnalysisProfileUtils.getEmbeddedAnalysisProfiles((ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)projectId));
        return ConfigurationToolsService.getToolsFromAnalysisProfiles(analysisProfiles, languages);
    }

    @GET
    @Path(value="analysis-profile/{analysisProfileName}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    @Operation(summary="Get analysis tools", description="Returns the available analysis tools for a specific analysis profile. Teamscale itself is not returned as a tool.", tags={"Analysis profiles"})
    public Set<EAnalysisTool> getAnalysisToolsForAnalysisProfile(@PathParam(value="analysisProfileName") String analysisProfileName, @Parameter(description="Languages to retrieve the analysis profile's tools for", required=true) @QueryParam(value="language") Set<ELanguage> languages) throws StorageException {
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
        return ConfigurationToolsService.getToolsFromAnalysisProfiles(List.of(analysisProfile), languages);
    }

    public static Set<EAnalysisTool> getToolsFromAnalysisProfiles(List<AnalysisProfile> analysisProfiles, Set<ELanguage> languages) {
        Set tools = AnalysisProfileUtils.getConfiguredTools(analysisProfiles);
        return tools.stream().filter(analysisTool -> analysisTool != EAnalysisTool.TEAMSCALE && analysisTool.isAvailableAndSupportsOneOf((Collection)languages)).collect(Collectors.toSet());
    }
}

