/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.webhook.github.data.CheckRunEventPayload;
import com.teamscale.service.webhook.github.data.PullRequestPayLoad;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import com.teamscale.service.webhook.github.event_handler.IMergeRequestUpdateTriggerSchedulingHelper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;

class GitHubCheckRunEventHandler
extends GitHubWebhookEventHandlerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> RELEVANT_CHECK_RUN_ACTIONS = Set.of("completed", "created", "rerequested");
    private final IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper;

    GitHubCheckRunEventHandler(IndexLayer indexLayer, IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper) {
        super(indexLayer);
        this.schedulingHelper = schedulingHelper;
    }

    @Override
    public void handle(@Language(value="JSON") String eventPayload) throws StorageException, JsonSerializationException {
        CheckRunEventPayload checkRunPayload = (CheckRunEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)eventPayload, CheckRunEventPayload.class);
        String action = checkRunPayload.action();
        String checkRunName = checkRunPayload.checkRun().name();
        if (!RELEVANT_CHECK_RUN_ACTIONS.contains(action)) {
            LOGGER.debug("Not scheduling merge request update triggers for check run '{}' because action '{}' is not relevant.", (Object)checkRunName, (Object)action);
            return;
        }
        if (GitHubCheckRunEventHandler.isTeamscaleCheckRun(checkRunName)) {
            return;
        }
        List<PullRequestPayLoad> affectedPullRequests = List.of(checkRunPayload.checkRun().pullRequests());
        LOGGER.debug("Scheduling merge request update triggers for check run '{}' for the following pull requests: {}", (Object)checkRunName, (Object)affectedPullRequests.stream().map(pullRequestPayLoad -> String.valueOf(pullRequestPayLoad.number())).collect(Collectors.joining(", ")));
        for (PullRequestPayLoad pullRequest : affectedPullRequests) {
            this.schedulingHelper.scheduleMergeRequestUpdateTriggersForPullRequest(checkRunPayload.repository().cloneUrl(), checkRunPayload.repository().fullName(), pullRequest.number());
        }
    }

    private static boolean isTeamscaleCheckRun(String checkRunName) {
        if (StringUtils.isEmpty((String)checkRunName)) {
            return false;
        }
        return StringUtils.startsWithIgnoreCase((String)checkRunName, (String)"Teamscale");
    }
}

