/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S6348")
public class WordPressUnfilteredHtmlCheck
extends WordPressConfigVisitor {
    private static final String MESSAGE = "Make sure allowing unfiltered HTML is intended.";
    private boolean configOccurred;

    @Override
    protected Set<String> configsToVisit() {
        return Collections.singleton("DISALLOW_UNFILTERED_HTML");
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.configOccurred = false;
        super.visitScript(tree);
        if (!this.configOccurred) {
            this.context().newFileIssue(this, MESSAGE);
        }
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        this.configOccurred = true;
        WordPressUnfilteredHtmlCheck.configValue(config).filter(CheckUtils::isFalseValue).ifPresent(v -> this.newIssue(config, MESSAGE));
    }
}

