/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.tree.symbols.SymbolQualifiedName;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseClauseTree;
import org.sonar.plugins.php.api.tree.statement.UseStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

class NamespaceNameResolvingVisitor
extends PHPVisitorCheck {
    protected final SymbolTableImpl symbolTable;
    private final Map<SymbolQualifiedName, Map<String, SymbolQualifiedName>> aliasesPerNamespace = new HashMap<SymbolQualifiedName, Map<String, SymbolQualifiedName>>();
    private SymbolQualifiedName currentNamespace = SymbolQualifiedName.GLOBAL_NAMESPACE;

    public NamespaceNameResolvingVisitor(SymbolTableImpl symbolTable) {
        this.aliasesPerNamespace.put(SymbolQualifiedName.GLOBAL_NAMESPACE, new HashMap());
        this.symbolTable = symbolTable;
    }

    public SymbolQualifiedName currentNamespace() {
        return this.currentNamespace;
    }

    @Override
    public void visitNamespaceStatement(NamespaceStatementTree tree) {
        NamespaceNameTree namespaceNameTree = tree.namespaceName();
        this.currentNamespace = namespaceNameTree != null ? SymbolQualifiedName.create(namespaceNameTree) : SymbolQualifiedName.GLOBAL_NAMESPACE;
        super.visitNamespaceStatement(tree);
        if (this.isBracketedNamespace(tree)) {
            this.currentNamespace = SymbolQualifiedName.GLOBAL_NAMESPACE;
        }
    }

    public boolean isBracketedNamespace(NamespaceStatementTree tree) {
        return tree.openCurlyBrace() != null;
    }

    @Override
    public void visitUseStatement(UseStatementTree tree) {
        SymbolQualifiedName namespacePrefix = NamespaceNameResolvingVisitor.getPrefix(tree);
        tree.clauses().forEach(useClauseTree -> {
            String alias = NamespaceNameResolvingVisitor.getAliasName(useClauseTree);
            SymbolQualifiedName originalName = NamespaceNameResolvingVisitor.getOriginalFullyQualifiedName(namespacePrefix, useClauseTree);
            this.aliasesPerNamespace.computeIfAbsent(this.currentNamespace, k -> new HashMap()).put(alias.toLowerCase(Locale.ROOT), originalName);
        });
    }

    @Nullable
    private static SymbolQualifiedName getPrefix(UseStatementTree useStatementTree) {
        NamespaceNameTree prefix = useStatementTree.prefix();
        return prefix == null ? null : SymbolQualifiedName.create(prefix);
    }

    private static SymbolQualifiedName getOriginalFullyQualifiedName(@Nullable SymbolQualifiedName namespacePrefix, UseClauseTree useClauseTree) {
        SymbolQualifiedName originalName = SymbolQualifiedName.create(useClauseTree.namespaceName());
        if (namespacePrefix != null) {
            return namespacePrefix.resolve(originalName);
        }
        return originalName;
    }

    private static String getAliasName(UseClauseTree useClauseTree) {
        NameIdentifierTree aliasNameTree = useClauseTree.alias();
        if (aliasNameTree != null) {
            return aliasNameTree.text();
        }
        return useClauseTree.namespaceName().name().text();
    }

    public QualifiedName getFullyQualifiedName(NamespaceNameTree name, Symbol.Kind kind) {
        if (name.isFullyQualified()) {
            return SymbolQualifiedName.create(name);
        }
        SymbolQualifiedName alias = this.resolveAlias(name);
        if (alias != null) {
            return alias;
        }
        if (name.hasQualifiers()) {
            return this.currentNamespace.resolve(SymbolQualifiedName.create(name));
        }
        if (kind == Symbol.Kind.CLASS) {
            return this.currentNamespace.resolve(SymbolQualifiedName.create(name));
        }
        Symbol symbol = this.symbolTable.getSymbol(this.currentNamespace.resolve(SymbolQualifiedName.create(name)));
        if (symbol != null) {
            return symbol.qualifiedName();
        }
        return SymbolQualifiedName.create(name);
    }

    @CheckForNull
    private SymbolQualifiedName resolveAlias(NamespaceNameTree namespaceNameTree) {
        if (namespaceNameTree.isFullyQualified()) {
            return null;
        }
        if (namespaceNameTree.namespaces().isEmpty()) {
            return this.lookupAlias(namespaceNameTree.name());
        }
        NameIdentifierTree potentialAlias = (NameIdentifierTree)namespaceNameTree.namespaces().iterator().next();
        SymbolQualifiedName aliasedNamespace = this.lookupAlias(potentialAlias);
        if (aliasedNamespace != null) {
            return aliasedNamespace.resolveAliasedName(namespaceNameTree);
        }
        return null;
    }

    @CheckForNull
    private SymbolQualifiedName lookupAlias(IdentifierTree identifierTree) {
        String alias = identifierTree.text().toLowerCase(Locale.ROOT);
        return Optional.ofNullable(this.aliasesPerNamespace.get(this.currentNamespace)).filter(map -> map.containsKey(alias)).orElse(this.aliasesPerNamespace.get(SymbolQualifiedName.GLOBAL_NAMESPACE)).get(alias);
    }
}

