/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.BiFunction;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SimpleCrudIndex<K, V>
extends IndexBase
implements IUtilityIndex {
    private final ISerializer<K, byte[]> keySerializer;
    private final ISerializer<V, byte[]> valueSerializer;

    public SimpleCrudIndex(@NonNull IStore store, @NonNull ISerializer<K, byte[]> keySerializer, @NonNull ISerializer<V, byte[]> valueSerializer) {
        super(store);
        this.keySerializer = Objects.requireNonNull(keySerializer, "keySerializer");
        this.valueSerializer = Objects.requireNonNull(valueSerializer, "valueSerializer");
    }

    public ISerializer<K, byte[]> getKeySerializer() {
        return this.keySerializer;
    }

    public ISerializer<V, byte[]> getValueSerializer() {
        return this.valueSerializer;
    }

    public static <V> SimpleCrudIndex<ESingletonKey, V> forSingleKey(@NonNull IStore store, @NonNull ISerializer<V, byte[]> valueSerializer) {
        return new SimpleCrudIndex<ESingletonKey, V>(store, ISerializer.forEnumOrdinal(ESingletonKey.class), valueSerializer);
    }

    public void put(@NonNull K key, @NonNull V value) throws StorageException {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.store.put(this.serializeKey(key), this.serializeValue(value));
    }

    public void put(@NonNull PairList<@NonNull K, @NonNull V> keysAndValues) throws StorageException {
        Objects.requireNonNull(keysAndValues, "keysAndValues");
        PairList serializedKeysAndValues = new PairList(keysAndValues.size());
        for (Pair keyAndValue : keysAndValues) {
            Object key = Objects.requireNonNull(keyAndValue.getFirst(), "key");
            Object value = Objects.requireNonNull(keyAndValue.getSecond(), "value");
            serializedKeysAndValues.add((Object)this.serializeKey(key), (Object)this.serializeValue(value));
        }
        this.store.put((PairList<byte[], byte[]>)serializedKeysAndValues);
    }

    public boolean has(@NonNull K key) throws StorageException {
        Objects.requireNonNull(key, "key");
        return this.store.get(this.serializeKey(key)) != null;
    }

    public Optional<V> get(@NonNull K key) throws StorageException {
        Objects.requireNonNull(key, "key");
        byte[] value = this.store.get(this.serializeKey(key));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeValue(value));
    }

    public List<@Nullable V> get(@NonNull SequencedCollection<@NonNull K> keys) throws StorageException {
        List<byte @Nullable []> values = this.store.get(this.serializeKeys(keys));
        ArrayList<@Nullable V> result = new ArrayList<V>(values.size());
        for (byte[] value : values) {
            result.add(this.deserializeValue(value));
        }
        return result;
    }

    public Map<K, V> getValuesByKeys(SequencedCollection<K> keys) throws StorageException {
        List<byte @Nullable []> values = this.store.get(this.serializeKeys(keys));
        HashMap<E, @Nullable V> result = new HashMap(values.size());
        Iterator keyIterator = keys.iterator();
        for (byte[] value : values) {
            result.put(keyIterator.next(), this.deserializeValue(value));
        }
        return result;
    }

    private @NonNull List<byte[]> serializeKeys(SequencedCollection<K> keys) throws StorageException {
        Objects.requireNonNull(keys, "keys");
        ArrayList<byte[]> serializedKeys = new ArrayList<byte[]>(keys.size());
        for (Object key : keys) {
            Objects.requireNonNull(key, "key");
            serializedKeys.add(this.serializeKey(key));
        }
        return serializedKeys;
    }

    public Collection<K> getKeys() throws StorageException {
        List<byte[]> serializedKeys = StorageUtils.listKeys(this.store);
        ArrayList<K> result = new ArrayList<K>(serializedKeys.size());
        for (byte[] serializedKey : serializedKeys) {
            result.add(this.deserializeKey(serializedKey));
        }
        return result;
    }

    public PairList<K, V> getEntries() throws StorageException {
        List<byte[]> serializedKeys = StorageUtils.listKeys(this.store);
        List<byte[]> serializedValues = this.store.get(serializedKeys);
        PairList result = new PairList(serializedKeys.size());
        CollectionUtils.forEachWithException(serializedKeys, serializedValues, (serializedKey, serializedValue) -> result.add(this.deserializeKey((byte[])serializedKey), this.deserializeValue((byte[])serializedValue)));
        return result;
    }

    public @Nullable V merge(@NonNull K key, @NonNull V value, BiFunction<@NonNull ? super V, @NonNull ? super V, @Nullable ? extends V> mergeFunction) throws StorageException {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(mergeFunction, "mergeFunction");
        return (V)this.compute(key, (ignored, existingValue) -> {
            if (existingValue == null) {
                return value;
            }
            return mergeFunction.apply((Object)existingValue, (Object)value);
        });
    }

    public @Nullable V compute(@NonNull K key, BiFunction<@Nullable ? super K, @Nullable ? super V, @Nullable ? extends V> computeFunction) throws StorageException {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(computeFunction, "computeFunction");
        Optional<V> oldValue = this.get(key);
        V newValue = computeFunction.apply(key, oldValue.orElse(null));
        if (newValue != null || !oldValue.isEmpty()) {
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
        }
        return newValue;
    }

    public void remove(@NonNull K key) throws StorageException {
        this.store.remove(this.serializeKey(key));
    }

    public void remove(Collection<K> keys) throws StorageException {
        ArrayList<byte[]> serializedKeys = new ArrayList<byte[]>(keys.size());
        for (K key : keys) {
            serializedKeys.add(this.serializeKey(key));
        }
        this.store.remove(serializedKeys);
    }

    public void clear() throws StorageException {
        StorageUtils.clearStore(this.store);
    }

    @Override
    public IStore getWrappedStore() {
        return this.store.getWrappedStore();
    }

    private byte[] serializeValue(V value) throws StorageException {
        return this.valueSerializer.serialize(value);
    }

    private V deserializeValue(byte[] value) throws StorageException {
        if (value == null) {
            return null;
        }
        return this.valueSerializer.deserialize(value);
    }

    private byte[] serializeKey(K key) throws StorageException {
        return this.keySerializer.serialize(key);
    }

    private K deserializeKey(byte[] serializedKey) throws StorageException {
        return this.keySerializer.deserialize(serializedKey);
    }

    @IndexValueClass(containedInBackup=true)
    public static enum ESingletonKey {
        INSTANCE;

    }
}

